/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class StringConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public StringConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public StringConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class type, Object value) {
        if (value == null || String.valueOf(value).isEmpty()) {
            return null;
        }
        if (value instanceof Clob) {
            StringBuilder sb = new StringBuilder(1024);
            CharBuffer cbuf = CharBuffer.allocate(1024);
            try {
                Reader rdr = ((Clob)value).getCharacterStream();
                while (rdr.read(cbuf) >= 0) {
                    cbuf.rewind();
                    sb.append(cbuf);
                    cbuf.rewind();
                }
            }
            catch (IOException e) {
                throw new ConversionException("Error reading from clob", e);
            }
            catch (SQLException e) {
                throw new ConversionException("Error reading from clob", e);
            }
            value = sb.toString();
        }
        try {
            return this.cleanseString(value.toString());
        }
        catch (ClassCastException e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }

    private String cleanseString(String value) {
        if (value == null) {
            return value;
        }
        StringBuffer buff = new StringBuffer();
        block3: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    buff.append(c);
                    continue block3;
                }
                default: {
                    if ((c < ' ' || c > '\ud7ff') && (c < '\ue000' || c > '\ufffd')) continue block3;
                    buff.append(c);
                }
            }
        }
        return buff.toString();
    }
}

