/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

import com.salesforce.dataloader.action.visitor.DAOLoadVisitor;
import com.salesforce.dataloader.client.DescribeRefObject;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dyna.BooleanConverter;
import com.salesforce.dataloader.dyna.DateConverter;
import com.salesforce.dataloader.dyna.DoubleConverter;
import com.salesforce.dataloader.dyna.FileByteArrayConverter;
import com.salesforce.dataloader.dyna.IntegerConverter;
import com.salesforce.dataloader.dyna.ObjectField;
import com.salesforce.dataloader.dyna.SObjectReference;
import com.salesforce.dataloader.dyna.SObjectReferenceConverter;
import com.salesforce.dataloader.dyna.StringConverter;
import com.salesforce.dataloader.exception.LoadException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.model.Row;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.SoapType;
import com.sforce.soap.partner.sobject.SObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.log4j.Logger;

public class SforceDynaBean {
    public static Logger logger = Logger.getLogger(DAOLoadVisitor.class);

    public static DynaProperty[] createDynaProps(DescribeSObjectResult describer, Controller controller) {
        Field[] fields = describer.getFields();
        ArrayList<DynaProperty> dynaProps = new ArrayList<DynaProperty>();
        for (Field field : fields) {
            DescribeRefObject refInfo;
            String fieldName = field.getName();
            Class<?> classType = SforceDynaBean.getConverterClass(field);
            dynaProps.add(new DynaProperty(fieldName, classType));
            FieldType fieldType = field.getType();
            String relationshipName = field.getRelationshipName();
            if (fieldType != FieldType.reference || field.getReferenceTo().length != 1 || relationshipName == null || relationshipName.length() <= 0 || (refInfo = controller.getReferenceDescribes().get(relationshipName)) == null) continue;
            for (String refFieldName : refInfo.getFieldInfoMap().keySet()) {
                dynaProps.add(new DynaProperty(ObjectField.formatAsString(relationshipName, refFieldName), SObjectReference.class));
            }
        }
        return dynaProps.toArray(new DynaProperty[dynaProps.size()]);
    }

    public static Class<?> getTypeClass(Field field) {
        Class classType;
        SoapType soapType = field.getSoapType();
        switch (soapType) {
            case dateTime: {
                classType = Calendar.class;
                break;
            }
            case ID: 
            case string: {
                classType = String.class;
                break;
            }
            case _double: {
                if (field.isExternalId()) {
                    classType = Double.class;
                    break;
                }
                classType = String.class;
                break;
            }
            case _int: {
                classType = Integer.class;
                break;
            }
            case _boolean: {
                classType = Boolean.class;
                break;
            }
            case date: {
                classType = Calendar.class;
                break;
            }
            case base64Binary: {
                classType = byte[].class;
                break;
            }
            default: {
                classType = String.class;
            }
        }
        return classType;
    }

    public static Class<?> getConverterClass(Field field) {
        Class classType;
        SoapType soapType = field.getSoapType();
        switch (soapType) {
            case dateTime: {
                classType = Calendar.class;
                break;
            }
            case ID: 
            case string: {
                classType = String.class;
                break;
            }
            case _double: {
                if (field.isExternalId()) {
                    classType = Double.class;
                    break;
                }
                classType = String.class;
                break;
            }
            case _int: {
                classType = Integer.class;
                break;
            }
            case _boolean: {
                classType = Boolean.class;
                break;
            }
            case date: {
                classType = Calendar.class;
                break;
            }
            case base64Binary: {
                classType = byte[].class;
                break;
            }
            default: {
                classType = String.class;
            }
        }
        return classType;
    }

    public static BasicDynaClass getDynaBeanInstance(DynaProperty[] dynaProps) {
        return new BasicDynaClass("sobject", null, dynaProps);
    }

    public static DynaBean convertToDynaBean(BasicDynaClass dynaClass, Row sforceDataRow) throws ConversionException, LoadException {
        DynaBean sforceObj = null;
        try {
            sforceObj = dynaClass.newInstance();
            BeanUtils.copyProperties(sforceObj, sforceDataRow);
            return sforceObj;
        }
        catch (IllegalAccessException e1) {
            logger.error(Messages.getString("Visitor.dynaBeanError", new Object[0]), e1);
            throw new LoadException(e1);
        }
        catch (InstantiationException e1) {
            logger.fatal(Messages.getString("Visitor.dynaBeanError", new Object[0]), e1);
            throw new LoadException(e1);
        }
        catch (InvocationTargetException e) {
            logger.error(Messages.getString("Visitor.invocationError", new Object[0]), e);
            throw new LoadException(e);
        }
    }

    public static void insertNullArray(Controller controller, SObject sObj, DynaBean dynaBean) {
        LinkedList<String> fieldsToNull = new LinkedList<String>();
        for (String string : controller.getMapper().getDestColumns()) {
            SforceDynaBean.handleNull(string, dynaBean, fieldsToNull, controller);
        }
        for (Map.Entry entry : controller.getMapper().getConstantsMap().entrySet()) {
            SforceDynaBean.handleNull((String)entry.getKey(), dynaBean, fieldsToNull, controller);
        }
        if (fieldsToNull.size() > 0) {
            sObj.setFieldsToNull(fieldsToNull.toArray(new String[fieldsToNull.size()]));
        }
    }

    private static void handleNull(String fieldName, DynaBean dynaBean, List<String> fieldsToNull, Controller controller) {
        Object o = dynaBean.get(fieldName);
        if (o != null && o instanceof SObjectReference && ((SObjectReference)o).isNull()) {
            fieldsToNull.add(SObjectReference.getRelationshipField(controller, fieldName));
        } else if (o == null || String.valueOf(o).length() == 0) {
            fieldsToNull.add(fieldName);
        }
    }

    public static SObject[] getSObjectArray(Controller controller, List<DynaBean> dynaBeans, String entityName, boolean insertNulls) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParameterLoadException {
        SObject[] sObjects = new SObject[dynaBeans.size()];
        for (int j = 0; j < sObjects.length; ++j) {
            DynaBean dynaBean = dynaBeans.get(j);
            SObject sObj = SforceDynaBean.getSObject(controller, entityName, dynaBean);
            if (insertNulls) {
                SforceDynaBean.insertNullArray(controller, sObj, dynaBean);
            }
            sObjects[j] = sObj;
        }
        return sObjects;
    }

    public static SObject getSObject(Controller controller, String entityName, DynaBean dynaBean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParameterLoadException {
        SObject sObj = new SObject();
        sObj.setType(entityName);
        Map fieldMap = BeanUtils.describe(dynaBean);
        for (String fName : fieldMap.keySet()) {
            if (fieldMap.get(fName) == null) continue;
            Object value = dynaBean.get(fName);
            if (value != null && value instanceof SObjectReference) {
                SObjectReference sObjRef = (SObjectReference)value;
                if (sObjRef.isNull()) continue;
                sObjRef.addReferenceToSObject(controller, sObj, fName);
                continue;
            }
            sObj.setField(fName, dynaBean.get(fName));
        }
        return sObj;
    }

    public static synchronized void registerConverters(Config cfg) {
        boolean useEuroDates = cfg.getBoolean("process.useEuropeanDates");
        TimeZone tz = cfg.getTimeZone();
        ConvertUtils.register(new DateConverter(tz, useEuroDates), Calendar.class);
        ConvertUtils.register(new DoubleConverter(), Double.class);
        ConvertUtils.register(new IntegerConverter(null), Integer.class);
        ConvertUtils.register(new BooleanConverter(), Boolean.class);
        ConvertUtils.register(new StringConverter(), String.class);
        ConvertUtils.register(new FileByteArrayConverter(), byte[].class);
        ConvertUtils.register(new SObjectReferenceConverter(), SObjectReference.class);
    }
}

