/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

import com.salesforce.dataloader.client.DescribeRefObject;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dyna.ObjectField;
import com.salesforce.dataloader.dyna.SforceDynaBean;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.sobject.SObject;
import org.apache.commons.beanutils.ConvertUtils;

public class SObjectReference {
    private final Object referenceExtIdValue;

    public SObjectReference(Object refValue) {
        if (refValue != null && String.valueOf(refValue).length() == 0) {
            refValue = null;
        }
        this.referenceExtIdValue = refValue;
    }

    public void addReferenceToSObject(Controller controller, SObject sObj, String refFieldName) throws ParameterLoadException {
        ObjectField refField = new ObjectField(refFieldName);
        String relationshipName = refField.getObjectName();
        String fieldName = refField.getFieldName();
        DescribeRefObject entityRefInfo = controller.getReferenceDescribes().get(relationshipName);
        SObject sObjRef = new SObject();
        sObjRef.setType(entityRefInfo.getObjectName());
        Class<?> typeClass = SforceDynaBean.getConverterClass(entityRefInfo.getFieldInfoMap().get(fieldName));
        Object extIdValue = ConvertUtils.convert(this.referenceExtIdValue.toString(), typeClass);
        sObjRef.setField(fieldName, extIdValue);
        sObj.addField(relationshipName, sObjRef);
    }

    public String toString() {
        return this.referenceExtIdValue == null ? "" : this.referenceExtIdValue.toString();
    }

    public int hashCode() {
        return this.referenceExtIdValue == null ? "".hashCode() : this.referenceExtIdValue.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof SObjectReference && (this.referenceExtIdValue == o || this.referenceExtIdValue != null && this.referenceExtIdValue.equals(((SObjectReference)o).referenceExtIdValue));
    }

    public Object getReferenceExtIdValue() {
        return this.referenceExtIdValue;
    }

    public static String getRelationshipField(Controller controller, String refFieldName) {
        String relName = new ObjectField(refFieldName).getObjectName();
        controller.getReferenceDescribes().get(relName).getFieldInfoMap();
        for (Field f : controller.getFieldTypes().getFields()) {
            if (f == null || !relName.equals(f.getRelationshipName())) continue;
            return f.getName();
        }
        return null;
    }

    public boolean isNull() {
        return this.referenceExtIdValue == null;
    }
}

