/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

public class ObjectField {
    private String objectName;
    private String fieldName;
    public static final String VALUE_SEPARATOR_CHAR = ":";

    public ObjectField(String objectName, String fieldName) {
        this.objectName = objectName;
        this.fieldName = fieldName;
    }

    public ObjectField(String objectField) {
        String[] refFieldNameInfo = objectField.split(VALUE_SEPARATOR_CHAR);
        this.objectName = refFieldNameInfo[0];
        this.fieldName = refFieldNameInfo[1];
    }

    public ObjectField(String[] objectFieldArray) {
        this.objectName = objectFieldArray[0];
        this.fieldName = objectFieldArray[1];
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public static String formatAsString(String objectName, String fieldName) {
        return objectName + VALUE_SEPARATOR_CHAR + fieldName;
    }

    public String toString() {
        return ObjectField.formatAsString(this.objectName, this.fieldName);
    }
}

