/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class IntegerConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public IntegerConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public IntegerConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class type, Object value) {
        if (value == null || String.valueOf(value).length() == 0) {
            return null;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        try {
            return new Integer(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

