/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

import com.sforce.ws.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class FileByteArrayConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public FileByteArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public FileByteArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class type, Object value) {
        if (value == null || String.valueOf(value).length() == 0) {
            return null;
        }
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            String absolutePath = new File(String.valueOf(value.toString())).getAbsolutePath();
            FileUtil.copy(new FileInputStream(absolutePath), byteStream);
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

