/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class DoubleConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public DoubleConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public DoubleConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class type, Object value) {
        if (value == null || String.valueOf(value).length() == 0) {
            return null;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        try {
            return new Double(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

