/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dyna;

import com.salesforce.dataloader.model.NACalendarValue;
import com.salesforce.dataloader.model.NATextValue;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.log4j.Logger;

public final class DateConverter
implements Converter {
    private static final TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");
    private static final List<String> supportedEuropeanPatterns = DateConverter.getSupportedPatterns(true);
    private static final List<String> supportedRegularPatterns = DateConverter.getSupportedPatterns(false);
    static Logger logger = Logger.getLogger(DateConverter.class);
    private final Object defaultValue;
    private final boolean useDefault;
    private final boolean useEuroDates;
    private final TimeZone timeZone;

    public DateConverter(TimeZone tz) {
        this(tz, null, false, false);
    }

    public DateConverter(TimeZone tz, boolean useEuroDateFormat) {
        this(tz, null, useEuroDateFormat, false);
    }

    public DateConverter(TimeZone tz, Object defaultValue, boolean useEuroDateFormat) {
        this(tz, defaultValue, useEuroDateFormat, true);
    }

    private DateConverter(TimeZone tz, Object defaultValue, boolean useEuroDateFormat, boolean useDefault) {
        this.timeZone = tz;
        this.defaultValue = defaultValue;
        this.useDefault = useDefault;
        this.useEuroDates = useEuroDateFormat;
    }

    public DateConverter(TimeZone tz, Object defaultValue) {
        this(tz, defaultValue, false, true);
    }

    private Calendar parseDate(TimeZone tz, String dateString, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(tz);
        return this.parseDate(dateString, df);
    }

    private Calendar parseDate(String dateString, DateFormat fmt) {
        ParsePosition pos = new ParsePosition(0);
        fmt.setLenient(false);
        Date date = fmt.parse(dateString, pos);
        if (date != null && pos.getIndex() == dateString.length()) {
            Calendar cal = Calendar.getInstance(this.timeZone);
            cal.setTime(date);
            return cal;
        }
        return null;
    }

    private Calendar tryParse(TimeZone tz, String dateString, String ... patterns) {
        if (patterns == null) {
            return null;
        }
        for (String pattern : patterns) {
            Calendar cal = this.parseDate(tz, dateString, pattern);
            if (cal == null) continue;
            return cal;
        }
        return null;
    }

    @Override
    public Object convert(Class type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof NATextValue) {
            return NACalendarValue.getInstance();
        }
        Calendar cal = Calendar.getInstance(this.timeZone);
        if (value instanceof Date) {
            cal.setTime((Date)value);
            return cal;
        }
        if (value instanceof Calendar) {
            return value;
        }
        String dateString = value.toString().trim();
        int len = dateString.length();
        if (len == 0) {
            return null;
        }
        String gmtDateString = null;
        if ("z".equalsIgnoreCase(dateString.substring(len - 1))) {
            gmtDateString = dateString.substring(0, len - 1);
        }
        for (String basePattern : this.useEuroDates ? supportedEuropeanPatterns : supportedRegularPatterns) {
            cal = gmtDateString != null ? this.tryParse(GMT_TZ, gmtDateString, basePattern) : this.tryParse(this.timeZone, dateString, basePattern, basePattern + "'Z'Z", basePattern + "'z'Z", basePattern + "z");
            if (cal == null) continue;
            return cal;
        }
        cal = this.parseDate(this.timeZone, dateString, "yyyy-MM-dd");
        if (cal != null) {
            return cal;
        }
        cal = this.useEuroDates ? this.tryParse(this.timeZone, dateString, "dd/MM/yyyy HH:mm:ss", "dd/MM/yyyy") : this.tryParse(this.timeZone, dateString, "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy");
        if (cal != null) {
            return cal;
        }
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        df.setTimeZone(this.timeZone);
        cal = this.parseDate(dateString, df);
        if (cal != null) {
            return cal;
        }
        df = DateFormat.getDateInstance(3);
        df.setTimeZone(this.timeZone);
        cal = this.parseDate(dateString, df);
        if (cal != null) {
            return cal;
        }
        if (this.useDefault) {
            return this.defaultValue;
        }
        throw new ConversionException("Failed to parse date: " + value);
    }

    private static List<String> getSupportedPatterns(boolean europeanDates) {
        ArrayList<String> basePatterns = new ArrayList<String>();
        ArrayList<String> extendedPatterns = new ArrayList<String>();
        extendedPatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSS");
        extendedPatterns.add("yyyy-MM-dd'T'HH:mm:ss");
        extendedPatterns.add("yyyy-MM-dd'T'HH:mm");
        extendedPatterns.add("yyyy-MM-dd'T'HH");
        extendedPatterns.add("yyyy-MM-dd'T'");
        ArrayList<String> extendedPatternsDateOnly = new ArrayList<String>();
        extendedPatternsDateOnly.add("yyyy-MM");
        extendedPatternsDateOnly.add("yyyyMMdd");
        extendedPatternsDateOnly.add("yyyy");
        ArrayList<Object> extendedPatternsWithoutT = new ArrayList<Object>();
        extendedPatternsWithoutT.add("yyyy-MM-dd HH:mm:ss.SSS");
        extendedPatternsWithoutT.add("yyyy-MM-dd HH:mm:ss");
        extendedPatternsWithoutT.add("yyyy-MM-dd HH:mm");
        extendedPatternsWithoutT.add("yyyy-MM-dd HH");
        ArrayList<String> basicPatterns = new ArrayList<String>();
        basicPatterns.add("yyyyMMdd'T'HH:mm:ss.SSS");
        basicPatterns.add("yyyyMMdd'T'HH:mm:ss");
        basicPatterns.add("yyyyMMdd'T'HH:mm");
        basicPatterns.add("yyyyMMdd'T'HH");
        basicPatterns.add("yyyyMMdd'T'");
        ArrayList<String> basicPatternsWithoutT = new ArrayList<String>();
        basicPatternsWithoutT.add("yyyyMMdd HH:mm:ss.SSS");
        basicPatternsWithoutT.add("yyyyMMdd HH:mm:ss");
        basicPatternsWithoutT.add("yyyyMMdd HH:mm");
        basicPatternsWithoutT.add("yyyyMMdd HH");
        ArrayList<String> fullBasicFormats = new ArrayList<String>();
        fullBasicFormats.add("yyyyMMdd'T'HHmmss");
        fullBasicFormats.add("yyyyMMdd'T'HHmm");
        fullBasicFormats.add("yyyyMMdd'T'HH");
        ArrayList<String> fullBasicFormatsWithoutT = new ArrayList<String>();
        fullBasicFormatsWithoutT.add("yyyyMMdd HHmmss");
        fullBasicFormatsWithoutT.add("yyyyMMdd HHmm");
        fullBasicFormatsWithoutT.add("yyyyMMdd HH");
        String baseDate = europeanDates ? "dd/MM/yyyy" : "MM/dd/yyyy";
        ArrayList slashPatternsWithoutT = new ArrayList();
        extendedPatternsWithoutT.add(baseDate + " HH:mm:ss.SSS");
        extendedPatternsWithoutT.add(baseDate + " HH:mm:ss");
        extendedPatternsWithoutT.add(baseDate + " HH:mm");
        extendedPatternsWithoutT.add(baseDate + " HH");
        extendedPatternsWithoutT.add(baseDate + " HHZ");
        ArrayList slashPatternsWithT = new ArrayList();
        extendedPatternsWithoutT.add(baseDate + "'T'HH:mm:ss.SSS");
        extendedPatternsWithoutT.add(baseDate + "'T'HH:mm:ss");
        extendedPatternsWithoutT.add(baseDate + "'T'HH:mm");
        extendedPatternsWithoutT.add(baseDate + "'T'HH");
        basePatterns.addAll(fullBasicFormatsWithoutT);
        basePatterns.addAll(fullBasicFormats);
        basePatterns.addAll(basicPatterns);
        basePatterns.addAll(basicPatternsWithoutT);
        basePatterns.addAll(extendedPatternsDateOnly);
        basePatterns.addAll(extendedPatterns);
        basePatterns.addAll(extendedPatternsWithoutT);
        basePatterns.addAll(slashPatternsWithoutT);
        basePatterns.addAll(slashPatternsWithT);
        ArrayList timeZones = new ArrayList();
        basePatterns.forEach(p -> timeZones.add(p + "Z"));
        basePatterns.addAll(timeZones);
        return basePatterns;
    }
}

