/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao.database;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.dao.database.DatabaseConfig;
import com.salesforce.dataloader.dao.database.DatabaseContext;
import com.salesforce.dataloader.dao.database.DatabaseReader;
import com.salesforce.dataloader.dao.database.SqlConfig;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.model.Row;
import java.io.File;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class DatabaseWriter
implements DataWriter {
    private static Logger logger = Logger.getLogger(DatabaseReader.class);
    private final BasicDataSource dataSource;
    private final Config config;
    private int currentRowNumber = 0;
    private final SqlConfig sqlConfig;
    private final DatabaseContext dbContext;

    public DatabaseWriter(Config config) throws DataAccessObjectInitializationException {
        this(config, config.getString("dataAccess.name"));
    }

    DatabaseWriter(Config config, String dbConfigName) throws DataAccessObjectInitializationException {
        this.config = config;
        String dbConfigFilename = config.constructConfigFilePath("database-conf.xml");
        if (!new File(dbConfigFilename).exists()) {
            throw new DataAccessObjectInitializationException(Messages.getFormattedString("DatabaseDAO.errorConfigFileExists", dbConfigFilename));
        }
        DatabaseConfig dbConfig = DatabaseConfig.getInstance(dbConfigFilename, dbConfigName);
        this.dataSource = dbConfig.getDataSource();
        this.sqlConfig = dbConfig.getSqlConfig();
        this.dbContext = new DatabaseContext(dbConfigName);
    }

    DatabaseWriter(Config config, String dbConfigName, BasicDataSource dataSource, SqlConfig sqlConfig) {
        this.config = config;
        this.dataSource = dataSource;
        this.sqlConfig = sqlConfig;
        this.dbContext = new DatabaseContext(dbConfigName);
    }

    @Override
    public void checkConnection() throws DataAccessObjectInitializationException {
        this.dbContext.checkConnection(this.dataSource);
    }

    @Override
    public void open() throws DataAccessObjectInitializationException {
        this.setupUpdate();
        this.dbContext.setOpen(true);
    }

    @Override
    public void close() {
        this.dbContext.close();
    }

    private void setupUpdate() throws DataAccessObjectInitializationException {
        this.dbContext.initConnection(this.dataSource);
        this.dbContext.replaceSqlParams(this.sqlConfig.getSqlString());
        this.dbContext.prepareStatement();
    }

    @Override
    public boolean writeRowList(List<Row> inputRowList) throws DataAccessObjectException {
        String errMsg;
        if (!this.dbContext.isOpen()) {
            throw new DataAccessObjectInitializationException(Messages.getString("DatabaseDAO.errorUpdateNotOpen", new Object[0]));
        }
        boolean success = true;
        int startingRowNumber = this.currentRowNumber++;
        try {
            if (inputRowList.size() == 1) {
                this.dbContext.setSqlParamValues(this.sqlConfig, this.config, inputRowList.get(0));
            } else {
                this.dbContext.getDataStatement().clearBatch();
                for (Row inputRow : inputRowList) {
                    this.dbContext.setSqlParamValues(this.sqlConfig, this.config, inputRow);
                    this.dbContext.getDataStatement().addBatch();
                    ++this.currentRowNumber;
                }
            }
        }
        catch (ParameterLoadException e) {
            throw new DataAccessObjectException(e.getMessage(), e);
        }
        catch (SQLException sqe) {
            String errMsg2 = Messages.getFormattedString("DatabaseDAO.sqlExceptionPrepareRow", new String[]{String.valueOf(this.currentRowNumber + 1), String.valueOf(startingRowNumber + 1), String.valueOf(startingRowNumber + inputRowList.size() + 1), this.dbContext.getDbConfigName(), sqe.getMessage()});
            logger.error(errMsg2, sqe);
            this.currentRowNumber = startingRowNumber + inputRowList.size();
            throw new DataAccessObjectException(errMsg2, sqe);
        }
        catch (Exception e) {
            String errMsg3 = Messages.getFormattedString("DatabaseDAO.exceptionPrepareRow", new String[]{String.valueOf(this.currentRowNumber + 1), String.valueOf(startingRowNumber + 1), String.valueOf(startingRowNumber + inputRowList.size() + 1), this.dbContext.getDbConfigName(), e.getMessage()});
            logger.error(errMsg3, e);
            this.currentRowNumber = startingRowNumber + inputRowList.size();
            throw new DataAccessObjectException(errMsg3, e);
        }
        try {
            int totalSuccessRows = 0;
            if (inputRowList.size() == 1) {
                this.dbContext.getDataStatement().executeUpdate();
                success = true;
                totalSuccessRows = 1;
            } else {
                int[] rowsUpdatedArray;
                for (int rowsUpdated : rowsUpdatedArray = this.dbContext.getDataStatement().executeBatch()) {
                    if (rowsUpdated != -2) continue;
                    totalSuccessRows = rowsUpdatedArray.length;
                    success = true;
                    break;
                }
            }
            logger.debug(Messages.getFormattedString("DatabaseDAO.updatedStatus", new String[]{String.valueOf(totalSuccessRows), String.valueOf(this.currentRowNumber)}));
            this.dbContext.getDataConnection().commit();
        }
        catch (SQLException sqe) {
            if (sqe instanceof BatchUpdateException) {
                int[] updateCountArray = ((BatchUpdateException)sqe).getUpdateCounts();
                for (int i = 0; i < updateCountArray.length; ++i) {
                    if (updateCountArray[i] != -3) continue;
                    success = false;
                    break;
                }
            }
            errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionWriteRow", new String[]{String.valueOf(this.currentRowNumber + 1 - inputRowList.size()), String.valueOf(this.currentRowNumber + 1), this.dbContext.getDbConfigName(), sqe.getMessage()});
            logger.error(errMsg, sqe);
            this.endException(inputRowList.size());
            throw new DataAccessObjectException(errMsg, sqe);
        }
        catch (Exception e) {
            errMsg = Messages.getFormattedString("DatabaseDAO.exceptionWriteRow", new String[]{String.valueOf(this.currentRowNumber + 1 - inputRowList.size()), String.valueOf(this.currentRowNumber + 1), this.dbContext.getDbConfigName(), e.getMessage()});
            logger.error(errMsg, e);
            this.endException(inputRowList.size());
            throw new DataAccessObjectException(errMsg, e);
        }
        return success;
    }

    @Override
    public boolean writeRow(Row inputRow) throws DataAccessObjectException {
        ArrayList<Row> inputRowList = new ArrayList<Row>();
        inputRowList.add(inputRow);
        return this.writeRowList(inputRowList);
    }

    private void endException(int batchSize) {
        try {
            this.dbContext.getDataConnection().rollback();
        }
        catch (SQLException sqe) {
            logger.error(Messages.getFormattedString("DatabaseDAO.sqlExceptionRollback", new String[]{String.valueOf(this.currentRowNumber + 1 - batchSize), String.valueOf(this.currentRowNumber + 1), this.dbContext.getDbConfigName(), sqe.getMessage()}), sqe);
        }
    }

    @Override
    public List<String> getColumnNames() {
        return new ArrayList<String>();
    }

    @Override
    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    @Override
    public void setColumnNames(List<String> columnNames) {
    }
}

