/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao.database;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.dao.DataReader;
import com.salesforce.dataloader.dao.database.DatabaseConfig;
import com.salesforce.dataloader.dao.database.DatabaseContext;
import com.salesforce.dataloader.dao.database.SqlConfig;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.model.Row;
import com.salesforce.dataloader.util.DAORowUtil;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class DatabaseReader
implements DataReader {
    private static Logger logger = Logger.getLogger(DatabaseReader.class);
    private final BasicDataSource dataSource;
    private final Config config;
    private List<String> columnNames = new ArrayList<String>();
    private int totalRows = 0;
    private int currentRowNumber = 0;
    private final SqlConfig sqlConfig;
    private final DatabaseContext dbContext;

    public DatabaseReader(Config config) throws DataAccessObjectInitializationException {
        this(config, config.getString("dataAccess.name"));
    }

    public DatabaseReader(Config config, String dbConfigName) throws DataAccessObjectInitializationException {
        this.config = config;
        String dbConfigFilename = config.constructConfigFilePath("database-conf.xml");
        if (!new File(dbConfigFilename).exists()) {
            throw new DataAccessObjectInitializationException(Messages.getFormattedString("DatabaseDAO.errorConfigFileExists", dbConfigFilename));
        }
        DatabaseConfig dbConfig = DatabaseConfig.getInstance(dbConfigFilename, dbConfigName);
        this.dataSource = dbConfig.getDataSource();
        this.sqlConfig = dbConfig.getSqlConfig();
        this.dbContext = new DatabaseContext(dbConfigName);
        this.columnNames = this.sqlConfig.getColumnNames();
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
    }

    @Override
    public void open() throws DataAccessObjectInitializationException {
        this.open(null);
    }

    public void open(Map<String, Object> params) throws DataAccessObjectInitializationException {
        this.currentRowNumber = 0;
        try {
            this.setupQuery(params);
        }
        catch (DataAccessObjectInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataAccessObjectInitializationException(e.getMessage(), e);
        }
        this.dbContext.setOpen(true);
    }

    private void setupQuery(Map<String, Object> params) throws DataAccessObjectInitializationException, ParameterLoadException, IllegalArgumentException {
        try {
            int fetchSize;
            this.dbContext.initConnection(this.dataSource);
            this.dbContext.replaceSqlParams(this.sqlConfig.getSqlString());
            PreparedStatement statement = this.dbContext.prepareStatement();
            this.dbContext.setSqlParamValues(this.sqlConfig, this.config, params);
            try {
                fetchSize = this.config.getInt("dataAccess.readBatchSize");
                if (fetchSize > 200) {
                    fetchSize = 200;
                }
            }
            catch (ParameterLoadException e) {
                logger.warn(Messages.getFormattedString("DatabaseDAO.errorGettingBatchSize", new String[]{String.valueOf(200), e.getMessage()}));
                fetchSize = 200;
            }
            statement.setFetchSize(fetchSize);
            this.dbContext.setDataResultSet(statement.executeQuery());
        }
        catch (SQLException sqe) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionSetup", new String[]{this.dbContext.getDbConfigName(), sqe.getMessage()});
            logger.error(errMsg, sqe);
            this.close();
            throw new DataAccessObjectInitializationException(errMsg, sqe);
        }
    }

    @Override
    public List<Row> readRowList(int maxRows) throws DataAccessObjectException {
        Row outputRow;
        ArrayList<Row> outputRows = new ArrayList<Row>();
        for (int i = 0; i < maxRows && (outputRow = this.readRow()) != null; ++i) {
            outputRows.add(outputRow);
        }
        return outputRows;
    }

    @Override
    public Row readRow() throws DataAccessObjectException {
        Row row = null;
        if (!this.dbContext.isOpen()) {
            this.open();
        }
        String currentColumnName = "";
        try {
            ResultSet rs = this.dbContext.getDataResultSet();
            if (rs != null && rs.next()) {
                row = new Row(this.columnNames.size());
                Iterator<String> iterator = this.columnNames.iterator();
                while (iterator.hasNext()) {
                    String columnName;
                    currentColumnName = columnName = iterator.next();
                    Object value = rs.getObject(columnName);
                    row.put(columnName, value);
                }
                ++this.currentRowNumber;
            }
            return row;
        }
        catch (SQLException sqe) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionReadRow", new String[]{currentColumnName, String.valueOf(this.currentRowNumber + 1), this.dbContext.getDbConfigName(), sqe.getMessage()});
            logger.error(errMsg, sqe);
            this.close();
            throw new DataAccessObjectException(errMsg, sqe);
        }
        catch (Exception e) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.exceptionReadRow", new String[]{currentColumnName, String.valueOf(this.currentRowNumber + 1), this.dbContext.getDbConfigName(), e.getMessage()});
            logger.error(errMsg, e);
            this.close();
            throw new DataAccessObjectException(errMsg, e);
        }
    }

    @Override
    public int getTotalRows() throws DataAccessObjectException {
        boolean skipRowCount = Config.DEFAULT_SKIP_TOTAL_COUNT;
        if (this.config.contains("dataAccess.skipTotalCount")) {
            skipRowCount = this.config.getBoolean("dataAccess.skipTotalCount");
        }
        if (skipRowCount) {
            return 0;
        }
        if (this.totalRows == 0) {
            this.totalRows = DAORowUtil.calculateTotalRows(this);
        }
        return this.totalRows;
    }

    @Override
    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public void checkConnection() throws DataAccessObjectInitializationException {
        this.dbContext.checkConnection(this.dataSource);
    }

    @Override
    public void close() {
        this.dbContext.close();
    }
}

