/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao.database;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.dao.database.SqlConfig;
import com.salesforce.dataloader.dyna.DateConverter;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DatabaseContext {
    private final String dbConfigName;
    private ResultSet dataResultSet;
    private Connection dataConnection;
    private PreparedStatement dataStatement;
    private List<String> currentSqlParamNames;
    private String currentSqlString;
    private boolean open = false;
    public static final String DEFAULT_CONFIG_FILENAME = "database-conf.xml";
    private static Logger logger = Logger.getLogger(DatabaseContext.class);

    public DatabaseContext(String dbConfigName) {
        this.dbConfigName = dbConfigName;
    }

    public void checkConnection(DataSource dataSource) throws DataAccessObjectInitializationException {
        this.initConnection(dataSource);
        this.closeConnection();
    }

    public void initConnection(DataSource dataSource) throws DataAccessObjectInitializationException {
        try {
            if (this.dataConnection == null || this.dataConnection.isClosed()) {
                this.dataConnection = dataSource.getConnection();
                this.dataConnection.setAutoCommit(false);
            }
        }
        catch (SQLException sqe) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionConnect", new String[]{this.dbConfigName, sqe.getMessage()});
            logger.error(errMsg, sqe);
            throw new DataAccessObjectInitializationException(errMsg, sqe);
        }
    }

    public void closeConnection() {
        try {
            if (this.dataConnection != null && !this.dataConnection.isClosed()) {
                this.dataConnection.close();
            }
        }
        catch (SQLException sqe) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionConnClose", new String[]{this.dbConfigName, sqe.getMessage()});
            logger.info(errMsg, sqe);
        }
    }

    public void replaceSqlParams(String sqlString) {
        int end;
        ArrayList<String> paramNames = new ArrayList<String>();
        boolean moreParams = false;
        int start = sqlString.indexOf("@");
        if (start > 0) {
            moreParams = true;
        }
        while (moreParams && (end = sqlString.indexOf("@", start + 1)) >= 0) {
            String paramName = sqlString.substring(start + 1, end);
            paramNames.add(paramName);
            start = sqlString.indexOf("@", end + 1);
            if (start >= 0) continue;
            moreParams = false;
        }
        String sqlStringReplace = new String(sqlString);
        for (String param : paramNames) {
            sqlStringReplace = sqlStringReplace.replaceFirst("@" + param + "@", "?");
        }
        this.currentSqlString = sqlStringReplace;
        this.currentSqlParamNames = paramNames;
    }

    public void setSqlParamValues(SqlConfig sqlConfig, Config config, Map<String, Object> paramValues) throws ParameterLoadException {
        Object sqlValue;
        if (sqlConfig.getSqlParams() == null) {
            return;
        }
        if (paramValues == null) {
            paramValues = new HashMap<String, Object>();
        }
        for (String paramName : sqlConfig.getSqlParams().keySet()) {
            String type = sqlConfig.getSqlParams().get(paramName);
            if (paramValues.containsKey(paramName)) {
                sqlValue = this.mapParamToDbType(config, paramValues.get(paramName), type);
                paramValues.put(paramName, sqlValue);
                continue;
            }
            if (config.contains(paramName)) {
                Object configValue = this.getConfigValue(config, paramName, type);
                Object sqlValue2 = this.mapParamToDbType(config, configValue, type);
                logger.info(Messages.getFormattedString("DatabaseDAO.sqlParamInfo", new String[]{paramName, sqlValue2.toString()}));
                paramValues.put(paramName, sqlValue2);
                continue;
            }
            String errMsg = Messages.getFormattedString("DatabaseDAO.errorParamMissing", new String[]{paramName, this.dbConfigName});
            logger.fatal(errMsg);
            throw new ParameterLoadException(errMsg);
        }
        int index = 1;
        for (String paramName : this.currentSqlParamNames) {
            sqlValue = paramValues.get(paramName);
            try {
                if (sqlValue != null) {
                    this.dataStatement.setObject(index, sqlValue);
                } else {
                    this.dataStatement.setNull(index, this.getSqlType(sqlConfig.getSqlParams().get(paramName)));
                }
            }
            catch (SQLException sqe) {
                String valueString = String.valueOf(sqlValue);
                String valueClass = String.valueOf(sqlValue == null ? null : sqlValue.getClass());
                String errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionParamReplace", new String[]{this.dbConfigName, paramName, valueString, valueClass, sqe.getMessage()});
                logger.error(errMsg, sqe);
                throw new ParameterLoadException(errMsg, sqe);
            }
            ++index;
        }
    }

    private int getSqlType(String type) {
        try {
            Class<?> cls = Class.forName(type);
            if (Timestamp.class.isAssignableFrom(cls)) {
                return 93;
            }
            if (Time.class.isAssignableFrom(cls)) {
                return 92;
            }
            if (Date.class.isAssignableFrom(cls)) {
                return 91;
            }
            if (Integer.TYPE.equals(cls) || Long.TYPE.equals(cls) || Float.TYPE.equals(cls) || Double.TYPE.equals(cls) || Number.class.isAssignableFrom(cls)) {
                return 2;
            }
            if (String.class.isAssignableFrom(cls)) {
                return 12;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Type not supported: " + type);
    }

    private Object getConfigValue(Config config, String paramName, String type) throws ParameterLoadException {
        Object value;
        try {
            value = type.equals(Date.class.getName()) || type.equals(Timestamp.class.getName()) || type.equals(Time.class.getName()) ? config.getDate(paramName) : (type.equals(Boolean.TYPE.getName()) ? Boolean.valueOf(config.getBoolean(paramName)) : (type.equals(Integer.TYPE.getName()) ? Integer.valueOf(config.getInt(paramName)) : (type.equals(Long.TYPE.getName()) ? Long.valueOf(config.getLong(paramName)) : (type.equals(Float.TYPE.getName()) ? Float.valueOf(config.getFloat(paramName)) : (type.equals(Double.TYPE.getName()) ? Double.valueOf(config.getDouble(paramName)) : config.getString(paramName))))));
        }
        catch (ParameterLoadException e) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.errorSqlParamReplace", new String[]{paramName, type, this.dbConfigName});
            logger.error(errMsg, e);
            throw new ParameterLoadException(errMsg, e);
        }
        return value;
    }

    private Object mapParamToDbType(Config cfg, Object paramValue, String type) throws ParameterLoadException {
        if (paramValue == null) {
            return paramValue;
        }
        try {
            Object sqlValue = type.equals(Date.class.getName()) ? new Date(this.getTimeInMillis(cfg.getTimeZone(), paramValue)) : (type.equals(Timestamp.class.getName()) ? new Timestamp(this.getTimeInMillis(cfg.getTimeZone(), paramValue)) : (type.equals(Time.class.getName()) ? new Time(this.getTimeInMillis(cfg.getTimeZone(), paramValue)) : paramValue));
            return sqlValue;
        }
        catch (Exception e) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.errorParamMapping", new String[]{paramValue.toString(), paramValue.getClass().getName(), type, e.getMessage()});
            logger.error(errMsg, e);
            throw new ParameterLoadException(errMsg, e);
        }
    }

    private long getTimeInMillis(TimeZone tz, Object paramValue) {
        if (paramValue instanceof Calendar) {
            return ((Calendar)paramValue).getTimeInMillis();
        }
        if (paramValue instanceof java.util.Date) {
            return ((java.util.Date)paramValue).getTime();
        }
        if (paramValue instanceof String) {
            Calendar cal = (Calendar)new DateConverter(tz).convert(Calendar.class, paramValue);
            return cal.getTimeInMillis();
        }
        throw new IllegalArgumentException(Messages.getFormattedString("DatabaseDAO.errorParamMappingType", paramValue.getClass().getName()));
    }

    public PreparedStatement prepareStatement() throws DataAccessObjectInitializationException {
        try {
            this.dataStatement = this.dataConnection.prepareStatement(this.currentSqlString);
            return this.dataStatement;
        }
        catch (SQLException sqe) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionPrepareStatement", new String[]{this.dbConfigName, sqe.getMessage()});
            logger.error(errMsg, sqe);
            throw new DataAccessObjectInitializationException(errMsg, sqe);
        }
    }

    public void close() {
        try {
            if (this.dataResultSet != null) {
                this.dataResultSet.close();
            }
            if (this.dataStatement != null) {
                this.dataStatement.close();
            }
            if (this.dataConnection != null && !this.dataConnection.isClosed()) {
                this.dataConnection.close();
            }
        }
        catch (SQLException sqe) {
            String errMsg = Messages.getFormattedString("DatabaseDAO.sqlExceptionConnClose", new String[]{this.dbConfigName, sqe.getMessage()});
            logger.info(errMsg, sqe);
        }
        this.setOpen(false);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public ResultSet getDataResultSet() {
        return this.dataResultSet;
    }

    public void setDataResultSet(ResultSet dataResultSet) {
        this.dataResultSet = dataResultSet;
    }

    public PreparedStatement getDataStatement() {
        return this.dataStatement;
    }

    public void setDataStatement(PreparedStatement dataStatement) {
        this.dataStatement = dataStatement;
    }

    public List<String> getCurrentSqlParamNames() {
        return this.currentSqlParamNames;
    }

    public void setCurrentSqlParamNames(List<String> currentSqlParamNames) {
        this.currentSqlParamNames = currentSqlParamNames;
    }

    public String getCurrentSqlString() {
        return this.currentSqlString;
    }

    public void setCurrentSqlString(String currentSqlString) {
        this.currentSqlString = currentSqlString;
    }

    public Connection getDataConnection() {
        return this.dataConnection;
    }

    public String getDbConfigName() {
        return this.dbConfigName;
    }
}

