/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao.csv;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.dao.csv.CSVColumnVisitor;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.model.Row;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CSVFileWriter
implements DataWriter {
    private static Logger logger = Logger.getLogger(CSVFileWriter.class);
    private final String fileName;
    private BufferedWriter fileOut;
    private List<String> columnNames = new ArrayList<String>();
    private int currentRowNumber = 0;
    private boolean open = false;
    private final String encoding;
    private final boolean capitalizedHeadings;

    public CSVFileWriter(String fileName, Config config) {
        this.fileName = fileName;
        this.capitalizedHeadings = true;
        this.encoding = config.getCsvWriteEncoding();
    }

    @Override
    public void checkConnection() throws DataAccessObjectInitializationException {
        this.open();
        this.close();
    }

    @Override
    public void open() throws DataAccessObjectInitializationException {
        try {
            this.fileOut = this.encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), this.encoding)) : new BufferedWriter(new FileWriter(this.fileName));
            this.currentRowNumber = 0;
            this.setOpen(true);
        }
        catch (IOException e) {
            String errMsg = Messages.getFormattedString("CSVWriter.errorOpening", this.fileName);
            logger.error(errMsg, e);
            throw new DataAccessObjectInitializationException(errMsg, e);
        }
    }

    @Override
    public void close() {
        if (this.fileOut != null) {
            try {
                this.fileOut.close();
            }
            catch (IOException e) {
                logger.error(Messages.getString("CSVWriter.errorClosing", new Object[0]), e);
            }
            if (!this.columnNames.isEmpty()) {
                this.columnNames.clear();
            }
        }
    }

    private void writeHeaderRow() throws DataAccessObjectInitializationException {
        CSVColumnVisitor visitor = new CSVColumnVisitor(this.fileOut);
        try {
            this.visitHeaderColumns(this.columnNames, visitor);
            this.fileOut.newLine();
            visitor.newRow();
        }
        catch (IOException e) {
            String errMsg = Messages.getString("CSVWriter.errorWriting", new Object[0]);
            logger.error(errMsg, e);
            throw new DataAccessObjectInitializationException(errMsg, e);
        }
    }

    @Override
    public boolean writeRow(Row row) throws DataAccessObjectException {
        CSVColumnVisitor visitor = new CSVColumnVisitor(this.fileOut);
        try {
            CSVFileWriter.visitColumns(this.columnNames, row, visitor);
            this.fileOut.newLine();
            visitor.newRow();
            ++this.currentRowNumber;
            return true;
        }
        catch (IOException e) {
            logger.error(Messages.getString("CSVWriter.errorWriting", new Object[0]), e);
            throw new DataAccessObjectException(Messages.getString("CSVWriter.errorWriting", new Object[0]), e);
        }
    }

    @Override
    public boolean writeRowList(List<Row> rows) throws DataAccessObjectException {
        boolean success = true;
        for (Row row : rows) {
            success = this.writeRow(row);
        }
        return success;
    }

    private void visitHeaderColumns(List<String> columnNames, CSVColumnVisitor visitor) throws IOException {
        for (String colName : columnNames) {
            String outColName = colName != null ? (this.capitalizedHeadings ? colName.toUpperCase() : colName) : "";
            visitor.visit(outColName);
        }
    }

    private static void visitColumns(List<String> columnNames, Row row, CSVColumnVisitor visitor) throws IOException {
        for (String colName : columnNames) {
            Object colVal = row.get(colName);
            visitor.visit(colVal != null ? colVal.toString() : "");
        }
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public synchronized void setColumnNames(List<String> columnNames) throws DataAccessObjectInitializationException {
        if (columnNames == null || columnNames.isEmpty()) {
            String errMsg = Messages.getString("CSVFileDAO.errorOpenNoHeaderRow", new Object[0]);
            logger.error(errMsg);
            throw new DataAccessObjectInitializationException(errMsg);
        }
        this.columnNames = columnNames;
        this.writeHeaderRow();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }
}

