/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao.csv;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataReader;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.DataAccessRowException;
import com.salesforce.dataloader.model.Row;
import com.salesforce.dataloader.util.DAORowUtil;
import com.sforce.async.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class CSVFileReader
implements DataReader {
    private static final Logger LOGGER = Logger.getLogger(CSVFileReader.class);
    private final Object lock = new Object();
    private File file;
    private FileInputStream input;
    private int totalRows;
    private CSVReader csvReader;
    private int currentRowNumber;
    private boolean forceUTF8;
    private List<String> headerRow;
    private boolean isOpen;
    private char[] csvDelimiters;

    public CSVFileReader(Config config) {
        this(new File(config.getString("dataAccess.name")), config, true);
    }

    public CSVFileReader(String filePath, Controller controller) {
        this(new File(filePath), controller.getConfig(), false);
    }

    public CSVFileReader(String filePath, Controller controller, boolean custDelimiter) {
        this(new File(filePath), controller.getConfig(), custDelimiter);
    }

    public CSVFileReader(File file, Config config) {
        this(file, config, true);
    }

    public CSVFileReader(File file, Config config, boolean custDelimiter) {
        this.file = file;
        this.forceUTF8 = config.getBoolean("dataAccess.readUTF8");
        StringBuilder separator = new StringBuilder();
        if (custDelimiter) {
            if (config.getBoolean("loader.csvComma")) {
                separator.append(",");
            }
            if (config.getBoolean("loader.csvTab")) {
                separator.append("\t");
            }
            if (config.getBoolean("loader.csvOther")) {
                separator.append(config.getString("loader.csvOtherValue"));
            }
        } else {
            separator.append(",");
        }
        this.csvDelimiters = separator.toString().toCharArray();
        if (this.csvDelimiters.length == 0) {
            String errorMsg = "No csv separator present! You need at least one separator character!";
            LOGGER.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    @Override
    public void checkConnection() throws DataAccessObjectInitializationException {
        this.open();
        this.close();
    }

    @Override
    public void open() throws DataAccessObjectInitializationException {
        if (this.isOpen) {
            this.close();
        }
        this.currentRowNumber = 0;
        this.initalizeInput(this.csvDelimiters);
        this.readHeaderRow();
        this.isOpen = true;
    }

    @Override
    public void close() {
        try {
            IOUtils.closeQuietly(this.input);
        }
        finally {
            this.input = null;
            this.csvReader = null;
            this.isOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isUTF8File(File file) {
        FileInputStream stream;
        block6: {
            boolean bl;
            stream = null;
            try {
                stream = new FileInputStream(file);
                if (stream.read() != 239 || stream.read() != 187 || stream.read() != 191) break block6;
                bl = true;
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Error in file when testing CSV");
                IOUtils.closeQuietly(stream);
            }
            catch (IOException io) {
                LOGGER.error("IO error when testing file");
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(stream);
            }
            IOUtils.closeQuietly(stream);
            return bl;
        }
        IOUtils.closeQuietly(stream);
        return false;
    }

    @Override
    public List<Row> readRowList(int maxRows) throws DataAccessObjectException {
        Row outputRow;
        ArrayList<Row> outputRows = new ArrayList<Row>();
        for (int i = 0; i < maxRows && (outputRow = this.readRow()) != null; ++i) {
            outputRows.add(outputRow);
        }
        return outputRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row readRow() throws DataAccessObjectException {
        ArrayList<String> record;
        if (!this.isOpen) {
            this.open();
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                record = this.csvReader.nextRecord();
            }
            catch (IOException e) {
                throw new DataAccessObjectException(e);
            }
        }
        if (!DAORowUtil.isValidRow(record)) {
            return null;
        }
        if (record.size() > this.headerRow.size()) {
            String errMsg = Messages.getFormattedString("CSVFileDAO.errorRowTooLarge", new String[]{String.valueOf(this.currentRowNumber), String.valueOf(record.size()), String.valueOf(this.headerRow.size())});
            throw new DataAccessRowException(errMsg);
        }
        Row row = new Row(record.size());
        for (int i = 0; i < this.headerRow.size(); ++i) {
            String value = (String)record.get(i);
            if (value == null) {
                value = "";
            }
            row.put(this.headerRow.get(i), (Object)value);
        }
        ++this.currentRowNumber;
        return row;
    }

    @Override
    public List<String> getColumnNames() {
        return this.headerRow;
    }

    @Override
    public int getTotalRows() throws DataAccessObjectException {
        if (this.totalRows == 0) {
            if (!this.isOpen) {
                throw new IllegalStateException("File is not open");
            }
            this.totalRows = DAORowUtil.calculateTotalRows(this);
        }
        return this.totalRows;
    }

    @Override
    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaderRow() throws DataAccessObjectInitializationException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.headerRow = this.csvReader.nextRecord();
            }
            if (this.headerRow == null) {
                LOGGER.error(Messages.getString("CSVFileDAO.errorHeaderRow", new Object[0]));
                throw new DataAccessObjectInitializationException(Messages.getString("CSVFileDAO.errorHeaderRow", new Object[0]));
            }
        }
        catch (IOException e) {
            String errMsg = Messages.getString("CSVFileDAO.errorHeaderRow", new Object[0]);
            LOGGER.error(errMsg, e);
            throw new DataAccessObjectInitializationException(errMsg, e);
        }
        finally {
            if (this.headerRow == null) {
                IOUtils.closeQuietly(this.input);
            }
        }
    }

    private void initalizeInput(char[] csvDelimiters) throws DataAccessObjectInitializationException {
        try {
            this.input = new FileInputStream(this.file);
            this.csvReader = this.forceUTF8 || this.isUTF8File(this.file) ? new CSVReader((InputStream)this.input, "UTF-8", csvDelimiters) : new CSVReader((InputStream)this.input, csvDelimiters);
            this.csvReader.setMaxRowsInFile(Integer.MAX_VALUE);
            this.csvReader.setMaxCharsInFile(Integer.MAX_VALUE);
        }
        catch (FileNotFoundException e) {
            String errMsg = Messages.getFormattedString("CSVFileDAO.errorOpen", this.file.getAbsolutePath());
            LOGGER.error(errMsg, e);
            throw new DataAccessObjectInitializationException(errMsg, e);
        }
        catch (UnsupportedEncodingException e) {
            String errMsg = Messages.getString("CSVFileDAO.errorUnsupportedEncoding", new Object[0]);
            LOGGER.error(errMsg, e);
            throw new DataAccessObjectInitializationException(errMsg, e);
        }
        finally {
            if (this.csvReader == null) {
                IOUtils.closeQuietly(this.input);
            }
        }
    }
}

