/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao.csv;

import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.Logger;

public class CSVColumnVisitor {
    private boolean first = true;
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private Writer writer;
    private static Logger logger = Logger.getLogger(CSVColumnVisitor.class);

    public CSVColumnVisitor(Writer writer) {
        this.writer = writer;
    }

    public void newRow() {
        this.first = true;
    }

    public void visit(String column) throws IOException {
        if (column == null) {
            column = "";
        }
        try {
            if (!this.first) {
                this.writer.write(44);
            } else {
                this.first = false;
            }
            this.writer.write(34);
            int len = column.length();
            for (int i = 0; i < len; ++i) {
                char c = column.charAt(i);
                if (c == '\"') {
                    this.writer.write("\"\"");
                    continue;
                }
                this.writer.write(c);
            }
            this.writer.write(34);
        }
        catch (IOException e) {
            logger.error(e);
            throw e;
        }
    }
}

