/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao;

import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.security.EncryptionAesUtil;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class EncryptedDataSource
extends BasicDataSource {
    private final EncryptionAesUtil encrypter = new EncryptionAesUtil();
    private static Logger logger = Logger.getLogger(EncryptedDataSource.class);

    @Override
    public synchronized void setPassword(String encodedPassword) {
        this.password = this.decode(encodedPassword);
    }

    private String decode(String password) {
        return new String(EncryptedDataSource.DecryptString(this.encrypter, password));
    }

    private static String DecryptString(EncryptionAesUtil encrypter, String encryptedString) {
        if (encryptedString != null && encryptedString.length() > 0) {
            try {
                return encrypter.decryptMsg(encryptedString);
            }
            catch (Exception e) {
                String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{"db password", String.class.getName()});
                logger.error(errMsg, e);
                e.printStackTrace();
            }
        }
        return null;
    }
}

