/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.dao;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.dao.DataAccessObject;
import com.salesforce.dataloader.dao.csv.CSVFileReader;
import com.salesforce.dataloader.dao.csv.CSVFileWriter;
import com.salesforce.dataloader.dao.database.DatabaseReader;
import com.salesforce.dataloader.dao.database.DatabaseWriter;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.UnsupportedDataAccessObjectException;
import org.apache.log4j.Logger;

public class DataAccessObjectFactory {
    private static Logger logger = Logger.getLogger(DataAccessObjectFactory.class);
    public static final String CSV_READ_TYPE = "csvRead";
    public static final String CSV_WRITE_TYPE = "csvWrite";
    public static final String DATABASE_READ_TYPE = "databaseRead";
    public static final String DATABASE_WRITE_TYPE = "databaseWrite";

    public DataAccessObject getDaoInstance(String daoType, Config config) throws DataAccessObjectInitializationException {
        DataAccessObject dao = null;
        logger.info(Messages.getFormattedString("DataAccessObjectFactory.creatingDao", new String[]{config.getString("dataAccess.name"), daoType}));
        if (CSV_READ_TYPE.equalsIgnoreCase(daoType)) {
            dao = new CSVFileReader(config);
        } else if (CSV_WRITE_TYPE.equalsIgnoreCase(daoType)) {
            dao = new CSVFileWriter(config.getString("dataAccess.name"), config);
        } else if (DATABASE_READ_TYPE.equalsIgnoreCase(daoType)) {
            dao = new DatabaseReader(config);
        } else if (DATABASE_WRITE_TYPE.equalsIgnoreCase(daoType)) {
            dao = new DatabaseWriter(config);
        } else {
            String errMsg = Messages.getFormattedString("DataAccessObjectFactory.daoTypeNotSupported", daoType);
            logger.error(errMsg);
            throw new UnsupportedDataAccessObjectException(errMsg);
        }
        return dao;
    }
}

