/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.controller;

import com.salesforce.dataloader.action.IAction;
import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.client.BulkClient;
import com.salesforce.dataloader.client.ClientBase;
import com.salesforce.dataloader.client.DescribeRefObject;
import com.salesforce.dataloader.client.PartnerClient;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.dao.DataAccessObject;
import com.salesforce.dataloader.dao.DataAccessObjectFactory;
import com.salesforce.dataloader.exception.ControllerInitializationException;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.exception.ProcessInitializationException;
import com.salesforce.dataloader.mapping.LoadMapper;
import com.salesforce.dataloader.mapping.Mapper;
import com.salesforce.dataloader.mapping.SOQLMapper;
import com.salesforce.dataloader.ui.LoaderWindow;
import com.salesforce.dataloader.util.AppUtil;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.ws.ConnectionException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Controller {
    private static final String LOG_CONF_OVERRIDE = "log-conf.xml";
    private static boolean isLogInitialized = false;
    public static final String CONFIG_DIR_PROP = "salesforce.config.dir";
    public static final String CONFIG_FILE = "config.properties";
    public static final String DEFAULT_CONFIG_FILE = "defaultConfig.properties";
    private static final String LAST_RUN_FILE_SUFFIX = "_lastRun.properties";
    private static final String CONFIG_DIR = "conf";
    private static String APP_NAME;
    public static String APP_VERSION;
    public static String API_VERSION;
    private static String APP_VENDOR;
    private static AppUtil.OSType OS_TYPE;
    private Config config;
    private Mapper mapper;
    private DataAccessObjectFactory daoFactory;
    private DataAccessObject dao;
    private BulkClient bulkClient;
    private PartnerClient partnerClient;
    private static Logger logger;
    private String appPath;

    private Controller(String name, boolean isBatchMode, String[] args) throws ControllerInitializationException {
        Controller.initStaticVariable();
        try {
            this.initConfig(name, isBatchMode, this.getConfigDirFromArgMap(args));
        }
        catch (Exception e) {
            logger.error("Exception happened in initConfig:", e);
            throw e;
        }
    }

    private String getConfigDirFromArgMap(String[] args) {
        HashMap argNameValuePair = new HashMap();
        Arrays.stream(args).forEach(arg -> {
            String[] argArray = arg.split("=");
            if (argArray.length == 2) {
                argNameValuePair.put(argArray[0], argArray[1]);
            }
        });
        return argNameValuePair.containsKey(CONFIG_DIR_PROP) ? (String)argNameValuePair.get(CONFIG_DIR_PROP) : null;
    }

    public static void initStaticVariable() throws ControllerInitializationException {
        Properties versionProps = new Properties();
        try {
            versionProps.load(Controller.class.getClassLoader().getResourceAsStream("com/salesforce/dataloader/version.properties"));
        }
        catch (IOException e) {
            throw new ControllerInitializationException(e);
        }
        APP_NAME = versionProps.getProperty("dataloader.name");
        APP_VENDOR = versionProps.getProperty("dataloader.vendor");
        APP_VERSION = versionProps.getProperty("dataloader.version");
        String[] dataloaderVersion = APP_VERSION.split("\\.");
        API_VERSION = dataloaderVersion[0] + "." + dataloaderVersion[1];
        OS_TYPE = AppUtil.getOSType();
    }

    public void setConfigDefaults() {
        this.config.setDefaults();
    }

    public synchronized void executeAction(ILoaderProgress monitor) throws DataAccessObjectException, OperationException {
        OperationInfo operation = this.config.getOperationInfo();
        IAction action = operation.instantiateAction(this, monitor);
        logger.info(Messages.getFormattedString("Controller.executeStart", (Object)operation));
        action.execute();
    }

    private void validateSession() {
        this.getPartnerClient().validateSession();
    }

    public void setFieldTypes() throws ConnectionException {
        this.validateSession();
        this.getPartnerClient().setFieldTypes();
    }

    public void setReferenceDescribes() throws ConnectionException {
        this.validateSession();
        this.getPartnerClient().setFieldReferenceDescribes();
    }

    private boolean loginIfSessionExists(ClientBase<?> clientToLogin) {
        if (!this.isLoggedIn()) {
            return false;
        }
        return clientToLogin.connect(this.getPartnerClient().getSession());
    }

    public boolean loginIfSessionExists() {
        return this.loginIfSessionExists(this.getClient());
    }

    public boolean setEntityDescribes() throws ConnectionException {
        this.validateSession();
        return this.getPartnerClient().setEntityDescribes();
    }

    public Map<String, DescribeGlobalSObjectResult> getEntityDescribes() {
        this.validateSession();
        return this.getPartnerClient().getDescribeGlobalResults();
    }

    public DescribeSObjectResult getFieldTypes() {
        this.validateSession();
        return this.getPartnerClient().getFieldTypes();
    }

    public Map<String, DescribeRefObject> getReferenceDescribes() {
        this.validateSession();
        return this.getPartnerClient().getReferenceDescribes();
    }

    public boolean login() throws ConnectionException {
        return this.login(this.getClient());
    }

    private boolean login(ClientBase<?> clientToLogin) throws ConnectionException {
        boolean loggedIn = this.isLoggedIn();
        if (!loggedIn) {
            loggedIn = this.getPartnerClient().connect();
        }
        return loggedIn && clientToLogin.connect(this.getPartnerClient().getSession());
    }

    public boolean isLoggedIn() {
        return this.getPartnerClient().isLoggedIn();
    }

    public void createDao() throws DataAccessObjectInitializationException {
        try {
            this.config.getStringRequired("dataAccess.name");
            this.dao = this.daoFactory.getDaoInstance(this.config.getStringRequired("dataAccess.type"), this.config);
        }
        catch (Exception e) {
            logger.fatal(Messages.getString("Controller.errorDAOCreate", new Object[0]), e);
            throw new DataAccessObjectInitializationException(Messages.getString("Controller.errorDAOCreate", new Object[0]), e);
        }
    }

    public void createMapper() throws MappingInitializationException {
        String mappingFile = this.config.getString("process.mappingFile");
        this.mapper = this.getConfig().getOperationInfo().isExtraction() ? new SOQLMapper(this.getPartnerClient(), this.dao.getColumnNames(), this.getFieldTypes().getFields(), mappingFile) : new LoadMapper(this.getPartnerClient(), this.dao.getColumnNames(), this.getFieldTypes().getFields(), mappingFile);
    }

    public void createAndShowGUI() throws ControllerInitializationException {
        File configFile = new File(this.config.getFilename());
        if (!configFile.canWrite()) {
            String errMsg = Messages.getFormattedString("Controller.errorConfigWritable", this.config.getFilename());
            String currentWorkingDir = System.getProperty("user.dir");
            if (currentWorkingDir.startsWith("/Volumes")) {
                errMsg = Messages.getString("Controller.errorConfigWritableDmg", new Object[0]);
            }
            logger.fatal(errMsg);
            throw new ControllerInitializationException(errMsg);
        }
        new LoaderWindow(this).run();
        this.saveConfig();
    }

    public static Controller getInstance(String name, boolean isBatchMode, String[] args) throws ControllerInitializationException {
        return new Controller(name, isBatchMode, args);
    }

    public synchronized boolean saveConfig() {
        try {
            this.config.save();
        }
        catch (IOException e) {
            logger.fatal(Messages.getFormattedString("Controller.errorConfigSave", this.config.getFilename()), e);
            return false;
        }
        catch (GeneralSecurityException e) {
            logger.fatal(Messages.getFormattedString("Controller.errorConfigSave", this.config.getFilename()), e);
            return false;
        }
        return true;
    }

    private static boolean createDir(File dirPath) {
        boolean isSuccessful = true;
        if (!dirPath.exists() || !dirPath.isDirectory()) {
            isSuccessful = dirPath.mkdirs();
            if (isSuccessful) {
                logger.info("Created config directory: " + dirPath);
            } else {
                logger.info("Unable to create config directory: " + dirPath);
            }
        } else {
            logger.info("Config directory already exists: " + dirPath);
        }
        return isSuccessful;
    }

    private static File getInstalledConfigDir(String binPath, int endIdx, String osAppendix) {
        if (endIdx != -1) {
            binPath = binPath.substring(0, endIdx);
        }
        return new File(binPath, osAppendix);
    }

    private static File getInstalledConfigDir() {
        File dir;
        String path;
        try {
            URI uri = Controller.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            path = Paths.get(uri).toFile().getAbsolutePath();
            logger.debug("The installation binary location is: " + path);
        }
        catch (URISyntaxException e) {
            logger.error("Can find binary's location", e);
            throw new RuntimeException(e);
        }
        switch (OS_TYPE) {
            case WINDOWS: {
                dir = Controller.getInstalledConfigDir(path, path.lastIndexOf(File.separator), CONFIG_DIR);
                break;
            }
            case MACOSX: {
                dir = Controller.getInstalledConfigDir(path, path.lastIndexOf("/Contents"), "Contents/Resources/conf");
                break;
            }
            default: {
                dir = Controller.getInstalledConfigDir(path, path.lastIndexOf(File.separator), CONFIG_DIR);
            }
        }
        logger.info("The installation configuration location is: " + dir.getAbsolutePath());
        return dir;
    }

    protected void initConfig(String name, boolean isBatchMode, String configDirParameter) throws ControllerInitializationException {
        File configDir;
        String configDirPath;
        Controller.initLog();
        String string = configDirPath = configDirParameter != null ? configDirParameter : Controller.getConfigDir();
        if (configDirPath == null) {
            configDir = Paths.get(System.getProperty("user.dir"), "configs").toFile();
            logger.debug(String.format("OS: %s, '%s' NOT provided, setting config dir to : %s", new Object[]{OS_TYPE, CONFIG_DIR_PROP, configDir}));
        } else {
            configDir = new File(configDirPath);
            logger.debug(String.format("OS: %s, '%s' provided, setting config dir to : %s", new Object[]{OS_TYPE, CONFIG_DIR_PROP, configDir}));
        }
        boolean isMkdirSuccessfulOrExisting = Controller.createDir(configDir);
        if (!isMkdirSuccessfulOrExisting) {
            String errorMsg = Messages.getMessage(this.getClass(), "errorCreatingOutputDir", configDir);
            logger.error(errorMsg);
            throw new ControllerInitializationException(errorMsg);
        }
        this.appPath = configDir.getAbsolutePath();
        File configFile = new File(this.appPath, CONFIG_FILE);
        String configPath = configFile.getAbsolutePath();
        logger.info("Looking for file in config path: " + configPath);
        if (!configFile.exists()) {
            File defaultConfigFile = new File(Controller.getInstalledConfigDir(), DEFAULT_CONFIG_FILE);
            logger.debug("Looking for file in config file " + defaultConfigFile.getAbsolutePath());
            if (defaultConfigFile.exists()) {
                try {
                    logger.info(String.format("User config file does not exist in '%s' Default config file is copied from '%s'", configPath, defaultConfigFile.getAbsolutePath()));
                    Files.copy(defaultConfigFile.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Failed to copy '%s' to '%s'", defaultConfigFile.getAbsolutePath(), configFile);
                    logger.warn(errorMsg, e);
                    throw new ControllerInitializationException(errorMsg, e);
                }
            }
            try {
                logger.info(String.format("Default config does not exist in '%s' Creating empty config file in '%s'", defaultConfigFile, configPath));
                configFile.createNewFile();
            }
            catch (IOException e) {
                String errorMsg = String.format("Failed to create a new config: '%s'", configPath);
                logger.warn(errorMsg, e);
                throw new ControllerInitializationException(errorMsg, e);
            }
            configFile.setWritable(true);
            configFile.setReadable(true);
        } else {
            logger.info("User config is found in " + configFile.getAbsolutePath());
        }
        try {
            String lastRunFileName = name + LAST_RUN_FILE_SUFFIX;
            this.config = new Config(this.getAppPath(), configPath, lastRunFileName);
            this.config.setDefaults();
            this.config.setBatchMode(isBatchMode);
            this.config.load();
            logger.info(Messages.getMessage(this.getClass(), "configInit", new Object[0]));
        }
        catch (IOException e) {
            throw new ControllerInitializationException(Messages.getMessage(this.getClass(), "errorConfigLoad", configPath), e);
        }
        catch (ProcessInitializationException e) {
            throw new ControllerInitializationException(Messages.getMessage(this.getClass(), "errorConfigLoad", configPath), e);
        }
        if (this.daoFactory == null) {
            this.daoFactory = new DataAccessObjectFactory();
        }
    }

    private static String getProductName() {
        return APP_NAME + " " + APP_VERSION;
    }

    public static synchronized void initLog() throws FactoryConfigurationError {
        if (isLogInitialized) {
            return;
        }
        try {
            File logConfXml = Paths.get(System.getProperty("user.dir"), "configs", LOG_CONF_OVERRIDE).toFile();
            if (logConfXml.exists()) {
                logger.info("Reading log-conf.xml in " + logConfXml.getAbsolutePath());
                if (logConfXml.canRead()) {
                    DOMConfigurator.configure(logConfXml.getAbsolutePath());
                } else {
                    logger.warn("Unable to read log-conf.xml in " + logConfXml.getAbsolutePath());
                }
            } else {
                logger.info("Using built-in logging configuration, no log-conf.xml in " + logConfXml.getAbsolutePath());
            }
            logger.info(Messages.getString("Controller.logInit", new Object[0]));
        }
        catch (Exception ex) {
            logger.error(Messages.getString("Controller.errorLogInit", new Object[0]));
            logger.error(ex);
            System.exit(1);
        }
        isLogInitialized = true;
    }

    public static String getConfigDir() {
        return System.getProperty(CONFIG_DIR_PROP);
    }

    public PartnerClient getPartnerClient() {
        if (this.partnerClient == null) {
            this.partnerClient = new PartnerClient(this);
        }
        return this.partnerClient;
    }

    private ClientBase getClient() {
        return this.config.useBulkAPIForCurrentOperation() ? this.getBulkClient() : this.getPartnerClient();
    }

    public BulkClient getBulkClient() {
        if (this.bulkClient == null) {
            this.bulkClient = new BulkClient(this);
            this.loginIfSessionExists(this.bulkClient);
        }
        return this.bulkClient;
    }

    public Config getConfig() {
        return this.config;
    }

    public DataAccessObject getDao() {
        return this.dao;
    }

    public void setLoaderConfig(Config config_) {
        this.config = config_;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setStatusFiles(String statusDirName, boolean createDir, boolean generateFiles) throws ProcessInitializationException {
        File statusDir = new File(statusDirName);
        if (statusDirName == null || statusDirName.length() == 0) {
            statusDir = new File(new File(this.appPath), "../status");
            statusDirName = statusDir.getAbsolutePath();
        }
        if (statusDir.exists() && !statusDir.isDirectory()) {
            throw new ProcessInitializationException(Messages.getFormattedString("Controller.invalidOutputDir", statusDirName));
        }
        if (!statusDir.exists()) {
            if (!createDir) {
                throw new ProcessInitializationException(Messages.getFormattedString("Controller.invalidOutputDir", statusDirName));
            }
            if (!statusDir.mkdirs()) {
                throw new ProcessInitializationException(Messages.getFormattedString("Controller.errorCreatingOutputDir", statusDirName));
            }
        }
        Date currentTime = new Date();
        SimpleDateFormat format = new SimpleDateFormat("MMddyyhhmmssSSS");
        String timestamp = format.format(currentTime);
        String successPath = this.config.getString("process.outputSuccess");
        if (generateFiles || successPath == null || successPath.length() == 0) {
            successPath = new File(statusDir, "success" + timestamp + ".csv").getAbsolutePath();
        }
        String errorPath = this.config.getString("process.outputError");
        if (generateFiles || errorPath == null || errorPath.length() == 0) {
            errorPath = new File(statusDir, "error" + timestamp + ".csv").getAbsolutePath();
        }
        try {
            this.validateFile(successPath);
            this.validateFile(errorPath);
        }
        catch (IOException e) {
            throw new ProcessInitializationException(e.getMessage(), e);
        }
        this.config.setValue("process.statusOutputDirectory", statusDirName);
        this.config.setValue("process.outputSuccess", successPath);
        this.config.setValue("process.outputError", errorPath);
    }

    private void validateFile(String filePath) throws IOException {
        block6: {
            File file = new File(filePath);
            String daoName = this.config.getString("dataAccess.name");
            if (!file.exists()) {
                try {
                    if (!file.createNewFile()) {
                        throw new IOException(Messages.getMessage(this.getClass(), "errorFileCreate", filePath));
                    }
                    break block6;
                }
                catch (IOException iox) {
                    throw new IOException(Messages.getMessage(this.getClass(), "errorFileCreate", filePath));
                }
            }
            if (!file.canWrite()) {
                throw new IOException(Messages.getMessage(this.getClass(), "errorFileWrite", new Object[0]) + filePath);
            }
            if (filePath.equals(daoName)) {
                throw new IOException(Messages.getMessage(this.getClass(), "errorSameFile", daoName, filePath));
            }
        }
    }

    public void logout() {
        if (this.partnerClient != null) {
            this.partnerClient.logout();
        }
        this.bulkClient = null;
        this.partnerClient = null;
    }

    public boolean attachmentsEnabled() {
        return !this.getConfig().useBulkAPIForCurrentOperation() || this.getConfig().getBoolean("sfdc.bulkApiZipContent");
    }

    public void clearMapper() {
        this.mapper = null;
    }

    static {
        logger = Logger.getLogger(Controller.class);
    }
}

