/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.config;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("messages");

    private Messages() {
    }

    public static String getString(String key, Object ... args) {
        return Messages.getString(key, false, args);
    }

    private static String getString(String key, boolean nullOk, Object ... args) {
        assert (key.contains("."));
        try {
            if (args == null) {
                return RESOURCE_BUNDLE.getString(key);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = "";
            }
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), args);
        }
        catch (MissingResourceException e) {
            return nullOk ? null : "!" + key + "!";
        }
    }

    public static String getMessage(String section, String key, boolean nullOk, Object ... args) {
        return Messages.getString(section + "." + key, nullOk, args);
    }

    public static String getMessage(String section, String key, Object ... args) {
        return Messages.getMessage(section, key, false, args);
    }

    public static String getMessage(Class<?> cls, String key, Object ... args) {
        return Messages.getMessage(cls, key, false, args);
    }

    public static String getMessage(Class<?> cls, String key, boolean nullOk, Object ... args) {
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            String msg = Messages.getMessage(currentClass.getSimpleName(), key, true, args);
            if (msg == null) continue;
            return msg;
        }
        return Messages.getMessage(cls.getSimpleName(), key, nullOk, args);
    }

    public static String getFormattedString(String key, Object arg) {
        return Messages.getString(key, arg);
    }

    public static String getFormattedString(String key, Object[] args) {
        return Messages.getString(key, args);
    }
}

