/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.config;

import com.salesforce.dataloader.config.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LastRun
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(LastRun.class);
    public static final String LAST_LOAD_BATCH_ROW = "process.lastLoadBatchRow";
    public static final String LAST_RUN_DATE = "process.lastRunDate";
    private static Map<String, String> paramNames = new HashMap<String, String>();
    private String filePath;
    private String filename;
    private boolean outputEnabled;

    public LastRun(String filename) {
        this.filename = filename;
        this.init(null, false);
    }

    public void init(String filePath, boolean outputEnabled) {
        this.filePath = filePath;
        this.outputEnabled = outputEnabled;
        paramNames.put(LAST_RUN_DATE, "");
        paramNames.put(LAST_LOAD_BATCH_ROW, "");
    }

    public String getFullPath() {
        return new File(this.filePath, this.filename).getAbsolutePath();
    }

    public void load() throws IOException {
        if (!this.outputEnabled) {
            return;
        }
        if (this.filePath == null) {
            logger.fatal(Messages.getString("LastRun.fileMissing", new Object[0]));
            throw new IOException(Messages.getString("LastRun.fileMissing", new Object[0]));
        }
        File lastRunFile = new File(this.filePath, this.filename);
        logger.info(Messages.getFormattedString("LastRun.fileInfo", lastRunFile.getAbsolutePath()));
        if (!lastRunFile.exists()) {
            lastRunFile.createNewFile();
        }
        try (FileInputStream in = new FileInputStream(lastRunFile);){
            this.load(in);
        }
    }

    public void save() throws IOException {
        if (!this.outputEnabled) {
            return;
        }
        if (this.filePath == null) {
            throw new IOException(Messages.getString("LastRun.fileMissing", new Object[0]));
        }
        try (FileOutputStream out = new FileOutputStream(new File(this.filePath, this.filename));){
            this.store(out, "Last Run Config");
        }
    }

    public boolean hasParameter(String paramName) {
        return paramNames.containsKey(paramName);
    }

    public void setDefault(String paramName, String paramValue) {
        if (!this.containsKey(paramName)) {
            this.setProperty(paramName, paramValue);
        }
    }
}

