/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.config;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.config.LastRun;
import com.salesforce.dataloader.config.LinkedProperties;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.exception.ConfigInitializationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.security.EncryptionAesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class Config {
    private static Logger logger = Logger.getLogger(Config.class);
    public static final int DEFAULT_EXTRACT_REQUEST_SIZE = 500;
    public static final int DEFAULT_MIN_RETRY_SECS = 2;
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final int MAX_RETRIES_LIMIT = 10;
    public static final int DEFAULT_CONNECTION_TIMEOUT_SECS = 60;
    public static final int DEFAULT_TIMEOUT_SECS = 540;
    public static final int DEFAULT_LOAD_BATCH_SIZE = 200;
    public static final int DEFAULT_DAO_WRITE_BATCH_SIZE = 500;
    public static final int DEFAULT_DAO_READ_BATCH_SIZE = 200;
    public static final int MAX_LOAD_BATCH_SIZE = 200;
    public static final int MAX_DAO_READ_BATCH_SIZE = 200;
    public static final int MAX_DAO_WRITE_BATCH_SIZE = 2000;
    public static final int MAX_BULK_API_BATCH_BYTES = 10000000;
    public static final int MAX_BULK_API_BATCH_SIZE = 10000;
    public static final int DEFAULT_BULK_API_BATCH_SIZE = 2000;
    public static final long DEFAULT_BULK_API_CHECK_STATUS_INTERVAL = 5000L;
    public static final String DEFAULT_ENDPOINT_URL = "https://login.salesforce.com";
    public static final Boolean DEFAULT_SKIP_TOTAL_COUNT = true;
    public static final String ID_COLUMN_NAME = "ID";
    public static final String ERROR_COLUMN_NAME = "ERROR";
    public static final String STATUS_COLUMN_NAME = "STATUS";
    private final Properties properties;
    public static final boolean BOOLEAN_DEFAULT = false;
    public static final double DOUBLE_DEFAULT = 0.0;
    public static final float FLOAT_DEFAULT = 0.0f;
    public static final int INT_DEFAULT = 0;
    public static final long LONG_DEFAULT = 0L;
    public static final String STRING_DEFAULT = "";
    public static final Map<String, String> MAP_STRING_DEFAULT = new LinkedHashMap<String, String>();
    public static final String HIDE_WELCOME_SCREEN = "loader.hideWelcome";
    public static final String CSV_DELIMETER_COMMA = "loader.csvComma";
    public static final String CSV_DELIMETER_TAB = "loader.csvTab";
    public static final String CSV_DELIMETER_OTHER = "loader.csvOther";
    public static final String CSV_DELIMETER_OTHER_VALUE = "loader.csvOtherValue";
    public static final String SFDC_INTERNAL = "sfdcInternal";
    public static final String SFDC_INTERNAL_IS_SESSION_ID_LOGIN = "sfdcInternal.isSessionIdLogin";
    public static final String SFDC_INTERNAL_SESSION_ID = "sfdcInternal.sessionId";
    public static final String USERNAME = "sfdc.username";
    public static final String PASSWORD = "sfdc.password";
    public static final String ENDPOINT = "sfdc.endpoint";
    public static final String PROXY_HOST = "sfdc.proxyHost";
    public static final String PROXY_PORT = "sfdc.proxyPort";
    public static final String PROXY_USERNAME = "sfdc.proxyUsername";
    public static final String PROXY_PASSWORD = "sfdc.proxyPassword";
    public static final String PROXY_NTLM_DOMAIN = "sfdc.proxyNtlmDomain";
    public static final String TIMEOUT_SECS = "sfdc.timeoutSecs";
    public static final String CONNECTION_TIMEOUT_SECS = "sfdc.connectionTimeoutSecs";
    public static final String NO_COMPRESSION = "sfdc.noCompression";
    public static final String ENABLE_RETRIES = "sfdc.enableRetries";
    public static final String MAX_RETRIES = "sfdc.maxRetries";
    public static final String MIN_RETRY_SLEEP_SECS = "sfdc.minRetrySleepSecs";
    public static final String DEBUG_MESSAGES = "sfdc.debugMessages";
    public static final String DEBUG_MESSAGES_FILE = "sfdc.debugMessagesFile";
    public static final String RESET_URL_ON_LOGIN = "sfdc.resetUrlOnLogin";
    public static final String TRUNCATE_FIELDS = "sfdc.truncateFields";
    public static final String BULK_API_ENABLED = "sfdc.useBulkApi";
    public static final String BULK_API_SERIAL_MODE = "sfdc.bulkApiSerialMode";
    public static final String BULK_API_CHECK_STATUS_INTERVAL = "sfdc.bulkApiCheckStatusInterval";
    public static final String BULK_API_ZIP_CONTENT = "sfdc.bulkApiZipContent";
    public static final String WIRE_OUTPUT = "sfdc.wireOutput";
    public static final String TIMEZONE = "sfdc.timezone";
    public static final String OAUTH_PARTIAL_BULK = "bulk";
    public static final String OAUTH_PARTIAL_PARTNER = "partner";
    public static final String OAUTH_PARTIAL_SERVER = "server";
    public static final String OAUTH_PARTIAL_CLIENTSECRET = "clientsecret";
    public static final String OAUTH_PARTIAL_CLIENTID = "clientid";
    public static final String OAUTH_PARTIAL_REDIRECTURI = "redirecturi";
    public static final String OAUTH_PARTIAL_BULK_CLIENTID = "bulk.clientid";
    public static final String OAUTH_PARTIAL_PARTNER_CLIENTID = "partner.clientid";
    public static final String OAUTH_ENVIRONMENTS = "sfdc.oauth.environments";
    public static final String OAUTH_ENVIRONMENT = "sfdc.oauth.environment";
    public static final String OAUTH_ACCESSTOKEN = "sfdc.oauth.accesstoken";
    public static final String OAUTH_REFRESHTOKEN = "sfdc.oauth.refreshtoken";
    public static final String OAUTH_SERVER = "sfdc.oauth.server";
    public static final String OAUTH_CLIENTSECRET = "sfdc.oauth.clientsecret";
    public static final String OAUTH_CLIENTID = "sfdc.oauth.clientid";
    public static final String OAUTH_REDIRECTURI = "sfdc.oauth.redirecturi";
    public static final String INSERT_NULLS = "sfdc.insertNulls";
    public static final String ENTITY = "sfdc.entity";
    public static final String LOAD_BATCH_SIZE = "sfdc.loadBatchSize";
    public static final String ASSIGNMENT_RULE = "sfdc.assignmentRule";
    public static final String EXTERNAL_ID_FIELD = "sfdc.externalIdField";
    public static final String EXTRACT_REQUEST_SIZE = "sfdc.extractionRequestSize";
    public static final String EXTRACT_SOQL = "sfdc.extractionSOQL";
    public static final String OPERATION = "process.operation";
    public static final String MAPPING_FILE = "process.mappingFile";
    public static final String EURO_DATES = "process.useEuropeanDates";
    public static final String OUTPUT_STATUS_DIR = "process.statusOutputDirectory";
    public static final String OUTPUT_SUCCESS = "process.outputSuccess";
    public static final String ENABLE_EXTRACT_STATUS_OUTPUT = "process.enableExtractStatusOutput";
    public static final String ENABLE_LAST_RUN_OUTPUT = "process.enableLastRunOutput";
    public static final String LAST_RUN_OUTPUT_DIR = "process.lastRunOutputDirectory";
    public static final String OUTPUT_ERROR = "process.outputError";
    public static final String LOAD_ROW_TO_START_AT = "process.loadRowToStartAt";
    public static final String INITIAL_LAST_RUN_DATE = "process.initialLastRunDate";
    public static final String ENCRYPTION_KEY_FILE = "process.encryptionKeyFile";
    public static final String DAO_TYPE = "dataAccess.type";
    public static final String DAO_NAME = "dataAccess.name";
    public static final String DAO_READ_BATCH_SIZE = "dataAccess.readBatchSize";
    public static final String DAO_WRITE_BATCH_SIZE = "dataAccess.writeBatchSize";
    public static final String DAO_SKIP_TOTAL_COUNT = "dataAccess.skipTotalCount";
    public static final String READ_UTF8 = "dataAccess.readUTF8";
    public static final String WRITE_UTF8 = "dataAccess.writeUTF8";
    private boolean dirty = false;
    private String filename;
    private final LastRun lastRun;
    private final EncryptionAesUtil encrypter = new EncryptionAesUtil();
    private boolean isBatchMode = false;
    private final String configDir;
    public static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String BULK_API_ENCODING = "UTF-8";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final List<ConfigListener> listeners = new ArrayList<ConfigListener>();

    public Config(String configDir, String filename, String lastRunFileName) throws ConfigInitializationException {
        this.properties = new LinkedProperties();
        this.configDir = configDir;
        this.filename = filename;
        this.lastRun = new LastRun(lastRunFileName);
    }

    public void initLastRunFile() {
        if (this.getBoolean(ENABLE_LAST_RUN_OUTPUT)) {
            String lastRunDir = this.getString(LAST_RUN_OUTPUT_DIR);
            if (lastRunDir == null || lastRunDir.length() == 0) {
                lastRunDir = this.configDir;
            }
            this.lastRun.init(lastRunDir, true);
            try {
                this.lastRun.load();
            }
            catch (IOException e) {
                logger.warn(Messages.getFormattedString("LastRun.errorLoading", new String[]{this.lastRun.getFullPath(), e.getMessage()}), e);
            }
        }
    }

    private boolean useBulkApiByDefault() {
        return false;
    }

    public void setDefaults() {
        this.setValue(HIDE_WELCOME_SCREEN, true);
        this.setValue(CSV_DELIMETER_COMMA, true);
        this.setValue(CSV_DELIMETER_TAB, true);
        this.setValue(CSV_DELIMETER_OTHER, false);
        this.setValue(CSV_DELIMETER_OTHER_VALUE, "-");
        this.setValue(ENDPOINT, DEFAULT_ENDPOINT_URL);
        this.setValue(LOAD_BATCH_SIZE, this.useBulkApiByDefault() ? 2000 : 200);
        this.setValue(LOAD_ROW_TO_START_AT, 0);
        this.setValue(TIMEOUT_SECS, 540);
        this.setValue(CONNECTION_TIMEOUT_SECS, 60);
        this.setValue(ENABLE_RETRIES, true);
        this.setValue(MAX_RETRIES, 3);
        this.setValue(MIN_RETRY_SLEEP_SECS, 2);
        this.setValue(ASSIGNMENT_RULE, STRING_DEFAULT);
        this.setValue(INSERT_NULLS, false);
        this.setValue(ENABLE_EXTRACT_STATUS_OUTPUT, false);
        this.setValue(ENABLE_LAST_RUN_OUTPUT, true);
        this.setValue(RESET_URL_ON_LOGIN, true);
        this.setValue(EXTRACT_REQUEST_SIZE, 500);
        this.setValue(DAO_WRITE_BATCH_SIZE, 500);
        this.setValue(DAO_READ_BATCH_SIZE, 200);
        this.setValue(TRUNCATE_FIELDS, true);
        this.setValue(BULK_API_ENABLED, this.useBulkApiByDefault());
        this.setValue(BULK_API_SERIAL_MODE, false);
        this.setValue(BULK_API_ZIP_CONTENT, false);
        this.setValue(BULK_API_CHECK_STATUS_INTERVAL, 5000L);
        this.setValue(WIRE_OUTPUT, false);
        this.setValue(TIMEZONE, TimeZone.getDefault().getID());
        this.setValue(SFDC_INTERNAL, false);
        this.setValue(SFDC_INTERNAL_IS_SESSION_ID_LOGIN, false);
        this.setValue(SFDC_INTERNAL_SESSION_ID, new String[]{null});
        this.setValue(OAUTH_SERVER, DEFAULT_ENDPOINT_URL);
        this.setValue(OAUTH_REDIRECTURI, DEFAULT_ENDPOINT_URL);
        this.setValue(OAUTH_ENVIRONMENTS, STRING_DEFAULT);
        this.setValue(OAUTH_ENVIRONMENT, STRING_DEFAULT);
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name) || this.lastRun.hasParameter(name) && this.lastRun.containsKey(name);
    }

    public boolean getBoolean(String name) {
        String value = this.getParamValue(name);
        if (value == null || value.length() == 0) {
            return false;
        }
        return value.equals(TRUE);
    }

    public double getDouble(String name) throws ParameterLoadException {
        double ival;
        String value = this.getParamValue(name);
        if (value == null || value.length() == 0) {
            return 0.0;
        }
        try {
            ival = new Double(value);
        }
        catch (NumberFormatException e) {
            String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{name, Double.class.getName()});
            logger.warn(errMsg, e);
            throw new ParameterLoadException(e.getMessage(), e);
        }
        return ival;
    }

    public float getFloat(String name) throws ParameterLoadException {
        String value = this.getParamValue(name);
        if (value == null || value.length() == 0) {
            return 0.0f;
        }
        float ival = 0.0f;
        try {
            ival = new Float(value).floatValue();
        }
        catch (NumberFormatException e) {
            String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{name, Float.class.getName()});
            logger.warn(errMsg, e);
            throw new ParameterLoadException(e.getMessage(), e);
        }
        return ival;
    }

    public int getInt(String name) throws ParameterLoadException {
        String value = this.getParamValue(name);
        if (value == null || value.length() == 0) {
            return 0;
        }
        int ival = 0;
        try {
            ival = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{name, Integer.class.getName()});
            logger.warn(errMsg, e);
            throw new ParameterLoadException(e.getMessage(), e);
        }
        return ival;
    }

    public long getLong(String name) throws ParameterLoadException {
        String value = this.getParamValue(name);
        if (value == null || value.length() == 0) {
            return 0L;
        }
        long ival = 0L;
        try {
            ival = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{name, Long.class.getName()});
            logger.warn(errMsg, e);
            throw new ParameterLoadException(e.getMessage(), e);
        }
        return ival;
    }

    public String getStringRequired(String name) throws ParameterLoadException {
        String value = this.getString(name);
        if (value == null || value.length() == 0) {
            String errMsg = Messages.getFormattedString("Config.errorNoRequiredParameter", name);
            logger.fatal(errMsg);
            throw new ParameterLoadException(errMsg);
        }
        return value;
    }

    public String getString(String name) {
        String value = this.getParamValue(name);
        if (value == null) {
            return STRING_DEFAULT;
        }
        return value;
    }

    public ArrayList<String> getStrings(String name) {
        String values = this.getString(name);
        ArrayList<String> list = new ArrayList<String>();
        if (values != null && !values.trim().isEmpty()) {
            Collections.addAll(list, values.trim().split(","));
        }
        return list;
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumClass, String name) {
        return Enum.valueOf(enumClass, this.getString(name));
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.getString(TIMEZONE));
    }

    public String getConfigFilename(String configFileProperty) {
        String value = this.getParamValue(configFileProperty);
        if (value == null) {
            return null;
        }
        return this.constructConfigFilePath(new File(value).getName());
    }

    public String getLastRunFilename() {
        return this.lastRun == null ? null : this.lastRun.getFullPath();
    }

    public String constructConfigFilePath(String configFilename) {
        File configPathFile = new File(this.filename).getParentFile();
        return new File(configPathFile, configFilename).getAbsolutePath();
    }

    public Date getDate(String name) throws ParameterLoadException {
        String value = this.getParamValue(name);
        if (value == null || value.length() == 0) {
            return Calendar.getInstance().getTime();
        }
        Date dval = null;
        try {
            dval = DATE_FORMATTER.parse(value);
        }
        catch (ParseException e) {
            String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{name, Date.class.getName()});
            logger.warn(errMsg, e);
            throw new ParameterLoadException(e.getMessage(), e);
        }
        return dval;
    }

    public Map<String, String> getMap(String name) throws ParameterLoadException {
        String[] pairs;
        String value = this.getParamValue(name);
        if (value == null || value.length() == 0) {
            return MAP_STRING_DEFAULT;
        }
        HashMap<String, String> mval = new HashMap<String, String>();
        for (String pair : pairs = value.split(",")) {
            String[] nameValue = pair.split("=");
            if (nameValue.length != 2) {
                String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{name, Map.class.getName()});
                logger.warn(errMsg);
                throw new ParameterLoadException(errMsg);
            }
            mval.put(nameValue[0], nameValue[1]);
        }
        return mval;
    }

    private String getParamValue(String name) {
        String value = this.lastRun.hasParameter(name) ? this.lastRun.getProperty(name) : (this.properties != null ? this.properties.getProperty(name) : null);
        return value;
    }

    public void list(PrintStream out) {
        this.properties.list(out);
        this.lastRun.list(out);
    }

    public void list(PrintWriter out) {
        this.properties.list(out);
        this.lastRun.list(out);
    }

    public void load() throws IOException, ConfigInitializationException {
        if (this.filename == null) {
            logger.fatal(Messages.getString("Config.fileMissing", new Object[0]));
            throw new IOException(Messages.getString("Config.fileMissing", new Object[0]));
        }
        try (FileInputStream in = new FileInputStream(this.filename);){
            this.load(in);
        }
    }

    private void load(InputStream in) throws ConfigInitializationException, IOException {
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            logger.fatal(Messages.getFormattedString("Config.errorPropertiesLoad", e.getMessage()));
            throw e;
        }
        this.postLoad(this.properties);
        this.dirty = false;
    }

    private void postLoad(Map values) throws ConfigInitializationException {
        Map propMap = values;
        this.initEncryption(propMap);
        this.decryptPasswordProperty(values, PASSWORD);
        this.decryptPasswordProperty(values, PROXY_PASSWORD);
        this.decryptPasswordProperty(values, OAUTH_ACCESSTOKEN);
        this.decryptPasswordProperty(values, OAUTH_REFRESHTOKEN);
    }

    private void decryptPasswordProperty(Map values, String propertyName) throws ConfigInitializationException {
        Map propMap = values;
        if (propMap.containsKey(propertyName)) {
            String propValue = Config.decryptProperty(this.encrypter, propMap, propertyName, this.isBatchMode());
            if (propValue == null) {
                propValue = STRING_DEFAULT;
            }
            propMap.put(propertyName, propValue);
        }
    }

    public void loadParameterOverrides(Map<String, String> configOverrideMap) throws ParameterLoadException, ConfigInitializationException {
        if (configOverrideMap.containsKey(INITIAL_LAST_RUN_DATE)) {
            this.lastRun.setDefault("process.lastRunDate", configOverrideMap.get(INITIAL_LAST_RUN_DATE));
        }
        this.postLoad(configOverrideMap);
        this.putValue(configOverrideMap);
        this.initLastRunFile();
    }

    private static String decryptProperty(EncryptionAesUtil encrypter, Map<String, String> propMap, String propName, boolean isBatch) throws ParameterLoadException {
        String propValue = propMap.get(propName);
        if (propValue != null && propValue.length() > 0) {
            try {
                return encrypter.decryptMsg(propValue);
            }
            catch (GeneralSecurityException e) {
                if (isBatch) {
                    String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{propName, String.class.getName()});
                    logger.error(errMsg, e);
                    throw new ParameterLoadException(errMsg, e);
                }
                return null;
            }
            catch (Exception e) {
                String errMsg = Messages.getFormattedString("Config.errorParameterLoad", new String[]{propName, String.class.getName()});
                logger.error(errMsg, e);
                throw new ParameterLoadException(errMsg, e);
            }
        }
        return propValue;
    }

    private void initEncryption(Map<String, String> values) throws ConfigInitializationException {
        String keyFile = values.get(ENCRYPTION_KEY_FILE);
        if (keyFile != null && keyFile.length() != 0) {
            try {
                this.encrypter.setCipherKeyFromFilePath(keyFile);
            }
            catch (Exception e) {
                String errMsg = Messages.getFormattedString("Config.errorSecurityInit", new String[]{keyFile, e.getMessage()});
                logger.error(errMsg);
                throw new ConfigInitializationException(errMsg);
            }
        }
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            list.add((String)en.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public void putValue(Map<String, String> values) throws ParameterLoadException, ConfigInitializationException {
        for (String key : values.keySet()) {
            this.putValue(key, values.get(key));
        }
    }

    public void putValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setValue(name, value);
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException, GeneralSecurityException {
        if (this.filename == null) {
            throw new IOException(Messages.getString("Config.fileMissing", new Object[0]));
        }
        String oldPassword = this.encryptProperty(PASSWORD);
        String oldProxyPassword = this.encryptProperty(PROXY_PASSWORD);
        String oauthAccessToken = this.getString(OAUTH_ACCESSTOKEN);
        String oauthRefreshToken = this.getString(OAUTH_REFRESHTOKEN);
        this.putValue(PASSWORD, STRING_DEFAULT);
        this.putValue(PROXY_PASSWORD, STRING_DEFAULT);
        this.putValue(OAUTH_ACCESSTOKEN, STRING_DEFAULT);
        this.putValue(OAUTH_REFRESHTOKEN, STRING_DEFAULT);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.filename);
            this.save(out, "Loader Config");
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.putValue(PASSWORD, oldPassword);
            this.putValue(PROXY_PASSWORD, oldProxyPassword);
            this.putValue(OAUTH_ACCESSTOKEN, oauthAccessToken);
            this.putValue(OAUTH_REFRESHTOKEN, oauthRefreshToken);
        }
        this.lastRun.save();
    }

    public void saveLastRun() throws IOException {
        this.lastRun.save();
    }

    private String encryptProperty(String propName) throws GeneralSecurityException, UnsupportedEncodingException {
        String oldValue = this.getString(propName);
        if (oldValue != null && oldValue.length() > 0) {
            this.putValue(propName, this.encrypter.encryptMsg(oldValue));
        }
        return oldValue;
    }

    private void save(OutputStream out, String header) throws IOException {
        this.properties.store(out, header);
        this.dirty = false;
    }

    public void setValue(String name, Map<String, String> valueMap) {
        StringBuilder sb = new StringBuilder();
        for (String key : valueMap.keySet()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(key + "=" + valueMap.get(key));
        }
        this.putValue(name, sb.toString());
    }

    public void setFilename(String name) {
        this.filename = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setValue(String name, double value) {
        this.setProperty(name, Double.toString(value));
    }

    public void setValue(String name, float value) {
        this.setProperty(name, Float.toString(value));
    }

    public void setValue(String name, int value) {
        this.setProperty(name, Integer.toString(value));
    }

    public void setValue(String name, long value) {
        this.setProperty(name, Long.toString(value));
    }

    public void setValue(String name, String ... values) {
        if (values != null && values.length > 1) {
            StringJoiner joiner = new StringJoiner(",");
            for (String value : values) {
                joiner.add(value);
            }
            this.setProperty(name, joiner.toString());
        } else if (values != null && values.length > 0) {
            this.setProperty(name, values[0]);
        } else {
            this.setProperty(name, null);
        }
    }

    public void setValue(String name, boolean value) {
        this.setProperty(name, Boolean.toString(value));
    }

    public void setValue(String name, Date value) {
        this.setProperty(name, DATE_FORMATTER.format(value));
    }

    private void setProperty(String name, String newValue) {
        boolean paramChanged;
        String oldValue = this.getString(name);
        boolean bl = oldValue == null || oldValue.length() == 0 ? newValue != null && newValue.length() > 0 : (paramChanged = !oldValue.equals(newValue));
        if (paramChanged) {
            this.dirty = true;
            this.configChanged(name, oldValue, newValue);
            if (this.lastRun.hasParameter(name)) {
                this.lastRun.put(name, newValue);
            } else {
                this.properties.put(name, newValue);
            }
        }
    }

    public boolean isBatchMode() {
        return this.isBatchMode;
    }

    public void setBatchMode(boolean isBatchMode) {
        this.isBatchMode = isBatchMode;
    }

    public int getLoadBatchSize() {
        int maxBatchSize;
        boolean bulkApi = this.isBulkAPIEnabled();
        int bs = -1;
        try {
            bs = this.getInt(LOAD_BATCH_SIZE);
        }
        catch (ParameterLoadException parameterLoadException) {
            // empty catch block
        }
        int n = maxBatchSize = bulkApi ? 10000 : 200;
        return bs > maxBatchSize ? maxBatchSize : (bs > 0 ? bs : this.getDefaultBatchSize(bulkApi));
    }

    public int getDefaultBatchSize(boolean bulkApi) {
        return bulkApi ? 2000 : 200;
    }

    public boolean useBulkAPIForCurrentOperation() {
        return this.isBulkAPIEnabled() && this.isBulkApiOperation();
    }

    public boolean isBulkAPIEnabled() {
        return this.getBoolean(BULK_API_ENABLED);
    }

    private boolean isBulkApiOperation() {
        return this.getOperationInfo().bulkAPIEnabled();
    }

    public OperationInfo getOperationInfo() {
        return this.getEnum(OperationInfo.class, OPERATION);
    }

    public String getCsvWriteEncoding() {
        if (Charset.defaultCharset().equals(UTF8) || this.getBoolean(WRITE_UTF8)) {
            return UTF8.name();
        }
        return Charset.defaultCharset().name();
    }

    public synchronized void addListener(ConfigListener l) {
        this.listeners.add(l);
    }

    private synchronized void configChanged(String key, String oldValue, String newValue) {
        for (ConfigListener l : this.listeners) {
            l.configValueChanged(key, oldValue, newValue);
        }
    }

    public String getOAuthEnvironmentString(String environmentName, String name) {
        return this.getString("sfdc.oauth." + environmentName + "." + name);
    }

    public void setOAuthEnvironmentString(String environmentName, String name, String ... values) {
        this.setValue("sfdc.oauth." + environmentName + "." + name, values);
    }

    public void setOAuthEnvironment(String environment) {
        String clientId = this.getBoolean(BULK_API_ENABLED) ? this.getOAuthEnvironmentString(environment, OAUTH_PARTIAL_BULK_CLIENTID) : this.getOAuthEnvironmentString(environment, OAUTH_PARTIAL_PARTNER_CLIENTID);
        if (clientId == null || clientId.isEmpty()) {
            clientId = this.getOAuthEnvironmentString(environment, OAUTH_PARTIAL_CLIENTID);
        }
        this.setValue(OAUTH_ENVIRONMENT, environment);
        this.setValue(OAUTH_SERVER, this.getOAuthEnvironmentString(environment, OAUTH_PARTIAL_SERVER));
        this.setValue(OAUTH_CLIENTID, clientId);
        this.setValue(OAUTH_CLIENTSECRET, this.getOAuthEnvironmentString(environment, OAUTH_PARTIAL_CLIENTSECRET));
        this.setValue(OAUTH_REDIRECTURI, this.getOAuthEnvironmentString(environment, OAUTH_PARTIAL_REDIRECTURI));
    }

    public static interface ConfigListener {
        public void configValueChanged(String var1, String var2, String var3);
    }
}

