/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.client;

public class SessionInfo {
    private final String sessionId;
    private final String serverUrl;

    SessionInfo(String sessionId, String server) {
        this.sessionId = sessionId;
        this.serverUrl = server;
    }

    SessionInfo() {
        this(null, null);
    }

    public boolean isSessionValid() {
        return this.sessionId != null;
    }

    public void validate() throws NotLoggedInException {
        if (!this.isSessionValid()) {
            throw new NotLoggedInException(this);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getServer() {
        return this.serverUrl;
    }

    public static class NotLoggedInException
    extends RuntimeException {
        private NotLoggedInException(SessionInfo sess) {
            super(sess.sessionId == null ? "Not Logged In" : "Session is expired");
        }
    }
}

