/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.client;

import com.salesforce.dataloader.client.ClientBase;
import com.salesforce.dataloader.client.DescribeRefObject;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dyna.SforceDynaBean;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.exception.PasswordExpiredException;
import com.salesforce.dataloader.ui.UIUtils;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.log4j.Logger;

public class PartnerClient
extends ClientBase<PartnerConnection> {
    private static Logger LOG = Logger.getLogger(PartnerClient.class);
    PartnerConnection client;
    private final ClientOperation<SaveResult[], SObject[]> INSERT_OPERATION = new ClientOperation<SaveResult[], SObject[]>(){

        @Override
        public String getName() {
            return "insert";
        }

        @Override
        public SaveResult[] run(SObject[] sObjects) throws ConnectionException {
            return PartnerClient.this.getClient().create(sObjects);
        }
    };
    private final ClientOperation<SaveResult[], SObject[]> UPDATE_OPERATION = new ClientOperation<SaveResult[], SObject[]>(){

        @Override
        public String getName() {
            return "update";
        }

        @Override
        public SaveResult[] run(SObject[] sObjects) throws ConnectionException {
            return PartnerClient.this.getClient().update(sObjects);
        }
    };
    private final ClientOperation<UpsertResult[], SObject[]> UPSERT_OPERATION = new ClientOperation<UpsertResult[], SObject[]>(){

        @Override
        public String getName() {
            return "upsert";
        }

        @Override
        public UpsertResult[] run(SObject[] sObjects) throws ConnectionException {
            return PartnerClient.this.getClient().upsert(PartnerClient.this.config.getString("sfdc.externalIdField"), sObjects);
        }
    };
    private final ClientOperation<DeleteResult[], String[]> DELETE_OPERATION = new ClientOperation<DeleteResult[], String[]>(){

        @Override
        public String getName() {
            return "delete";
        }

        @Override
        public DeleteResult[] run(String[] ids) throws ConnectionException {
            return PartnerClient.this.getClient().delete(ids);
        }
    };
    private final ClientOperation<QueryResult, String> QUERY_OPERATION = new ClientOperation<QueryResult, String>(){

        @Override
        public String getName() {
            return "query";
        }

        @Override
        public QueryResult run(String queryString) throws ConnectionException {
            return PartnerClient.this.getClient().query(queryString);
        }
    };
    private final ClientOperation<QueryResult, String> QUERY_ALL_OPERATION = new ClientOperation<QueryResult, String>(){

        @Override
        public String getName() {
            return "queryAll";
        }

        @Override
        public QueryResult run(String queryString) throws ConnectionException {
            return PartnerClient.this.getClient().queryAll(queryString);
        }
    };
    private final ClientOperation<QueryResult, String> QUERY_MORE_OPERATION = new ClientOperation<QueryResult, String>(){

        @Override
        public String getName() {
            return "queryMore";
        }

        @Override
        public QueryResult run(String queryString) throws ConnectionException {
            return PartnerClient.this.getClient().queryMore(queryString);
        }
    };
    private final ClientOperation<LoginResult, PartnerConnection> LOGIN_OPERATION = new ClientOperation<LoginResult, PartnerConnection>(){

        @Override
        public String getName() {
            return "login";
        }

        @Override
        public LoginResult run(PartnerConnection client) throws ConnectionException {
            ConnectorConfig cc = client.getConfig();
            return client.login(cc.getUsername(), cc.getPassword());
        }
    };
    private final ClientOperation<DescribeGlobalResult, Object> DESCRIBE_GLOBAL_OPERATION = new ClientOperation<DescribeGlobalResult, Object>(){

        @Override
        public String getName() {
            return "describeGlobal";
        }

        @Override
        public DescribeGlobalResult run(Object ignored) throws ConnectionException {
            return PartnerClient.this.getClient().describeGlobal();
        }
    };
    private final ClientOperation<DescribeSObjectResult, String> DESCRIBE_SOBJECT_OPERATION = new ClientOperation<DescribeSObjectResult, String>(){

        @Override
        public String getName() {
            return "describeSObject";
        }

        @Override
        public DescribeSObjectResult run(String entity) throws ConnectionException {
            return PartnerClient.this.getClient().describeSObject(entity);
        }
    };
    private DescribeGlobalResult entityTypes;
    private final Map<String, DescribeRefObject> referenceDescribes = new HashMap<String, DescribeRefObject>();
    private final Map<String, DescribeGlobalSObjectResult> describeGlobalResults = new HashMap<String, DescribeGlobalSObjectResult>();
    private final Map<String, DescribeSObjectResult> entityDescribes = new HashMap<String, DescribeSObjectResult>();
    private final boolean enableRetries;
    private final int maxRetries;
    private final Map<String, Field> fieldsByName = new HashMap<String, Field>();

    public PartnerClient(Controller controller) {
        super(controller, LOG);
        int retries = -1;
        this.enableRetries = this.config.getBoolean("sfdc.enableRetries");
        if (this.enableRetries) {
            try {
                retries = Math.min(10, this.config.getInt("sfdc.maxRetries"));
            }
            catch (ParameterLoadException e) {
                retries = 3;
            }
        }
        this.maxRetries = retries;
    }

    public boolean connect() throws ConnectionException {
        return this.login();
    }

    @Override
    protected boolean connectPostLogin(ConnectorConfig cc) {
        int querySize;
        if (this.getClient() == null) {
            throw new IllegalStateException("Client should be logged in already");
        }
        this.getClient().setCallOptions(ClientBase.getClientName(this.config), null);
        try {
            querySize = this.config.getInt("sfdc.extractionRequestSize");
        }
        catch (ParameterLoadException e) {
            querySize = 500;
        }
        if (querySize > 0) {
            this.getClient().setQueryOptions(querySize);
        }
        if (this.config.getString("sfdc.assignmentRule").length() > 14) {
            String rule = this.config.getString("sfdc.assignmentRule");
            if (rule.length() > 15) {
                rule = rule.substring(0, 15);
            }
            this.getClient().setAssignmentRuleHeader(rule, false);
        }
        this.getClient().setAllowFieldTruncationHeader(this.config.getBoolean("sfdc.truncateFields"));
        this.getClient().setDisableFeedTrackingHeader(true);
        return true;
    }

    public UpsertResult[] loadUpserts(List<DynaBean> dynaBeans) throws ConnectionException {
        UpsertResult[] ur = this.runOperation(this.UPSERT_OPERATION, this.getSobjects(dynaBeans, this.UPSERT_OPERATION.getName()));
        for (int j = 0; j < ur.length; ++j) {
            if (ur[j].getSuccess()) {
                if (ur[j].getCreated()) {
                    this.logger.debug(Messages.getString("Client.itemCreated", new Object[0]) + ur[j].getId());
                } else {
                    this.logger.debug(Messages.getString("Client.itemUpdated", new Object[0]) + ur[j].getId());
                }
            }
            this.processResult(ur[j].getSuccess(), "Client.itemUpserted", ur[j].getId(), ur[j].getErrors(), j);
        }
        return ur;
    }

    public SaveResult[] loadUpdates(List<DynaBean> dynaBeans) throws ConnectionException {
        return this.runSaveOperation(dynaBeans, this.UPDATE_OPERATION, false);
    }

    public SaveResult[] loadInserts(List<DynaBean> dynaBeans) throws ConnectionException {
        return this.runSaveOperation(dynaBeans, this.INSERT_OPERATION, true);
    }

    private SaveResult[] runSaveOperation(List<DynaBean> dynaBeans, ClientOperation<SaveResult[], SObject[]> op, boolean isInsert) throws ApiFault, ConnectionException {
        SaveResult[] sr = this.runOperation(op, this.getSobjects(dynaBeans, op.getName()));
        String saveMessage = isInsert ? "Client.itemCreated" : "Client.itemUpdated";
        for (int j = 0; j < sr.length; ++j) {
            this.processResult(sr[j].isSuccess(), saveMessage, sr[j].getId(), sr[j].getErrors(), j);
        }
        return sr;
    }

    private SObject[] getSobjects(List<DynaBean> dynaBeans, String opName) {
        try {
            SObject[] sobjects = SforceDynaBean.getSObjectArray(this.controller, dynaBeans, this.config.getString("sfdc.entity"), this.config.getBoolean("sfdc.insertNulls"));
            this.logger.debug(Messages.getString("Client.arraySize", new Object[0]) + sobjects.length);
            return sobjects;
        }
        catch (IllegalAccessException ex) {
            this.logger.error(Messages.getFormattedString("Client.operationError", new String[]{opName, ex.getMessage()}), ex);
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            this.logger.error(Messages.getFormattedString("Client.operationError", new String[]{opName, ex.getMessage()}), ex);
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            this.logger.error(Messages.getFormattedString("Client.operationError", new String[]{opName, ex.getMessage()}), ex);
            throw new RuntimeException(ex);
        }
        catch (ParameterLoadException ex) {
            this.logger.error(Messages.getFormattedString("Client.operationError", new String[]{opName, ex.getMessage()}), ex);
            throw new RuntimeException(ex);
        }
    }

    protected <R, A> R runOperation(ClientOperation<R, A> op, A arg) throws ConnectionException {
        this.logger.debug(Messages.getFormattedString("Client.beginOperation", op.getName()));
        if (op != this.LOGIN_OPERATION && !this.isSessionValid()) {
            this.connect();
        }
        int totalAttempts = 1 + (this.enableRetries ? this.maxRetries : 0);
        ConnectionException connectionException = null;
        for (int tryNum = 0; tryNum < totalAttempts; ++tryNum) {
            try {
                R result = op.run(arg);
                if (result == null) {
                    this.logger.info(Messages.getString("Client.resultNull", new Object[0]));
                }
                return result;
            }
            catch (ConnectionException ex) {
                this.logger.error(Messages.getFormattedString("Client.operationError", new String[]{op.getName(), ex.getMessage()}), ex);
                if (!this.checkConnectionException(ex, op.getName(), tryNum)) {
                    throw ex;
                }
                connectionException = ex;
                continue;
            }
        }
        throw connectionException;
    }

    public DeleteResult[] loadDeletes(List<DynaBean> dynaBeans) throws ConnectionException {
        String[] dels = new String[dynaBeans.size()];
        for (int i = 0; i < dynaBeans.size(); ++i) {
            DynaBean dynaBean = dynaBeans.get(i);
            String id = (String)dynaBean.get("Id");
            if (id == null) {
                id = "";
            }
            dels[i] = id;
        }
        this.logger.debug(Messages.getString("Client.arraySize", new Object[0]) + dels.length);
        DeleteResult[] result = this.runOperation(this.DELETE_OPERATION, dels);
        for (int j = 0; j < result.length; ++j) {
            this.processResult(result[j].isSuccess(), "Client.itemDeleted", result[j].getId(), result[j].getErrors(), j);
        }
        return result;
    }

    public QueryResult queryMore(String soql) throws ConnectionException {
        return this.runOperation(this.QUERY_MORE_OPERATION, soql);
    }

    public QueryResult query(String soql) throws ConnectionException {
        return this.runOperation(this.QUERY_OPERATION, soql);
    }

    public QueryResult queryAll(String soql) throws ConnectionException {
        return this.runOperation(this.QUERY_ALL_OPERATION, soql);
    }

    private void processResult(boolean success, String successMsgKey, String id, Error[] errors, int itemNbr) {
        if (success) {
            this.logger.debug(Messages.getString(successMsgKey, new Object[0]) + id);
        } else {
            for (Error err : errors) {
                int startRow;
                try {
                    startRow = this.config.getInt("process.loadRowToStartAt");
                }
                catch (ParameterLoadException e) {
                    startRow = 0;
                }
                this.logger.error(Messages.getString("Client.itemError", new Object[0]) + new Integer(itemNbr + startRow).toString());
                this.logger.error(Messages.getString("Client.errorCode", new Object[0]) + err.getStatusCode().toString());
                this.logger.error(Messages.getString("Client.errorMessage", new Object[0]) + err.getMessage());
            }
        }
    }

    @Override
    public PartnerConnection getClient() {
        return this.client;
    }

    public Map<String, DescribeGlobalSObjectResult> getDescribeGlobalResults() {
        return this.describeGlobalResults;
    }

    Map<String, DescribeSObjectResult> getEntityDescribeMap() {
        return this.entityDescribes;
    }

    DescribeGlobalResult getEntityTypes() {
        return this.entityTypes;
    }

    public DescribeSObjectResult getFieldTypes() {
        String entity = this.config.getString("sfdc.entity");
        try {
            return this.describeSObject(entity);
        }
        catch (ConnectionException e) {
            throw new RuntimeException("Unexpected failure describing main entity " + entity, e);
        }
    }

    public Map<String, DescribeRefObject> getReferenceDescribes() {
        return this.referenceDescribes;
    }

    boolean isSessionValid() {
        if (this.config.getBoolean("sfdcInternal") && this.config.getBoolean("sfdcInternal.isSessionIdLogin")) {
            return true;
        }
        if (this.config.getString("sfdc.oauth.accesstoken") != null && this.config.getString("sfdc.oauth.accesstoken").trim().length() > 0) {
            return true;
        }
        return this.isLoggedIn();
    }

    private boolean login() throws ConnectionException, ApiFault {
        this.disconnect();
        this.logger.info(Messages.getString("Client.sforceLogin", new Object[0]));
        ConnectorConfig cc = this.getLoginConnectorConfig();
        PartnerConnection conn = Connector.newConnection(cc);
        conn.setCallOptions(ClientBase.getClientName(this.config), null);
        String oauthAccessToken = this.config.getString("sfdc.oauth.accesstoken");
        if (oauthAccessToken != null && oauthAccessToken.trim().length() > 0) {
            this.setConfiguredSessionId(conn, oauthAccessToken);
        } else if (this.config.getBoolean("sfdcInternal") && this.config.getBoolean("sfdcInternal.isSessionIdLogin")) {
            this.setConfiguredSessionId(conn, this.config.getString("sfdcInternal.sessionId"));
        } else {
            this.setSessionRenewer(conn);
            this.loginInternal(conn);
        }
        return true;
    }

    private void setSessionRenewer(PartnerConnection conn) {
        conn.getConfig().setSessionRenewer(new SessionRenewer(){

            @Override
            public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig connectorConfig) throws ConnectionException {
                PartnerClient.this.loginInternal(conn);
                return null;
            }
        });
    }

    private void setConfiguredSessionId(PartnerConnection conn, String sessionId) throws ConnectionException {
        this.logger.info("Using manually configured session id to bypass login");
        conn.setSessionHeader(sessionId);
        try {
            conn.getUserInfo();
        }
        catch (ConnectionException e) {
            this.logger.error("Failed to get user info using manually configured session id", e);
            throw e;
        }
        this.loginSuccess(conn, this.getServerUrl(this.config.getString("sfdc.endpoint")));
    }

    private void loginInternal(PartnerConnection conn) throws ConnectionException, PasswordExpiredException {
        ConnectorConfig cc = conn.getConfig();
        try {
            this.logger.info(Messages.getMessage(this.getClass(), "sforceLoginDetail", cc.getAuthEndpoint(), cc.getUsername()));
            LoginResult loginResult = this.runOperation(this.LOGIN_OPERATION, conn);
            if (loginResult.getPasswordExpired()) {
                throw new PasswordExpiredException(Messages.getString("Client.errorExpiredPassword", new Object[0]));
            }
            conn.setSessionHeader(loginResult.getSessionId());
            String serverUrl = loginResult.getServerUrl();
            String server = this.getServerUrl(serverUrl);
            if (this.config.getBoolean("sfdc.resetUrlOnLogin")) {
                cc.setServiceEndpoint(serverUrl);
            }
            this.loginSuccess(conn, server);
        }
        catch (ConnectionException ex) {
            this.logger.error(Messages.getMessage(this.getClass(), "loginError", cc.getAuthEndpoint(), ex.getMessage()), ex);
            throw ex;
        }
    }

    private void loginSuccess(PartnerConnection conn, String serv) {
        this.client = conn;
        this.setSession(conn.getSessionHeader().getSessionId(), serv);
    }

    private String getServerStringFromUrl(URL url) {
        return url.getProtocol() + "://" + url.getAuthority();
    }

    private String getServerUrl(String serverUrl) {
        if (this.config.getBoolean("sfdc.resetUrlOnLogin")) {
            try {
                UIUtils.validateHttpsUrlAndThrow(serverUrl);
                return this.getServerStringFromUrl(new URL(serverUrl));
            }
            catch (MalformedURLException e) {
                this.logger.fatal("Unexpected error", e);
                throw new RuntimeException(e);
            }
        }
        return this.getDefaultServer();
    }

    public boolean logout() {
        try {
            PartnerConnection pc = this.getClient();
            if (pc != null) {
                pc.logout();
            }
        }
        catch (ConnectionException connectionException) {
        }
        finally {
            this.disconnect();
        }
        return true;
    }

    public void disconnect() {
        this.clearSession();
        this.client = null;
    }

    private void retrySleep(String operationName, int retryNum) {
        int sleepSecs;
        try {
            sleepSecs = this.config.getInt("sfdc.minRetrySleepSecs");
        }
        catch (ParameterLoadException e1) {
            sleepSecs = 2;
        }
        this.logger.info(Messages.getFormattedString("Client.retryOperation", new String[]{Integer.toString(retryNum + 1), operationName, Integer.toString(sleepSecs += retryNum * 10)}));
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean setEntityDescribes() throws ConnectionException {
        this.setEntityTypes();
        if (this.describeGlobalResults.isEmpty()) {
            for (DescribeGlobalSObjectResult res : this.entityTypes.getSobjects()) {
                if (res == null) continue;
                this.describeGlobalResults.put(res.getName(), res);
            }
        }
        return true;
    }

    private void setEntityTypes() throws ConnectionException {
        if (this.entityTypes == null) {
            this.entityTypes = this.runOperation(this.DESCRIBE_GLOBAL_OPERATION, null);
        }
    }

    public void setFieldReferenceDescribes() throws ConnectionException {
        this.referenceDescribes.clear();
        if (this.getDescribeGlobalResults().isEmpty()) {
            this.setEntityDescribes();
        }
        if (this.getFieldTypes() == null) {
            this.setFieldTypes();
        }
        if (this.getDescribeGlobalResults() != null) {
            Field[] entityFields;
            for (Field entityField : entityFields = this.getFieldTypes().getFields()) {
                if (!entityField.isCreateable() && !entityField.isUpdateable()) continue;
                String relationshipName = entityField.getRelationshipName();
                String[] referenceTos = entityField.getReferenceTo();
                if (referenceTos == null || referenceTos.length != 1 || referenceTos[0] == null || relationshipName == null || relationshipName.length() <= 0 || !entityField.isCreateable() && !entityField.isUpdateable()) continue;
                String refEntityName = referenceTos[0];
                Field[] refObjectFields = this.describeSObject(refEntityName).getFields();
                HashMap<String, Field> refFieldInfo = new HashMap<String, Field>();
                for (Field refField : refObjectFields) {
                    if (!refField.isExternalId()) continue;
                    refField.setCreateable(entityField.isCreateable());
                    refField.setUpdateable(entityField.isUpdateable());
                    refFieldInfo.put(refField.getName(), refField);
                }
                if (refFieldInfo.isEmpty()) continue;
                DescribeRefObject describe = new DescribeRefObject(refEntityName, refFieldInfo);
                this.referenceDescribes.put(relationshipName, describe);
            }
        }
    }

    public void setFieldTypes() throws ConnectionException {
        this.describeSObject(this.config.getString("sfdc.entity"));
    }

    public boolean isLoggedIn() {
        return this.getSession().isSessionValid();
    }

    public void validateSession() {
        this.getSession().validate();
    }

    @Override
    protected ConnectorConfig getConnectorConfig() {
        ConnectorConfig cc = super.getConnectorConfig();
        cc.setManualLogin(true);
        return cc;
    }

    private ConnectorConfig getLoginConnectorConfig() {
        ConnectorConfig cc = this.getConnectorConfig();
        String serverUrl = this.getDefaultServer();
        cc.setAuthEndpoint(serverUrl + DEFAULT_AUTH_ENDPOINT_URL.getPath());
        cc.setServiceEndpoint(serverUrl + DEFAULT_AUTH_ENDPOINT_URL.getPath());
        return cc;
    }

    private String getDefaultServer() {
        String serverUrl = this.config.getString("sfdc.endpoint");
        if (serverUrl == null || serverUrl.length() == 0) {
            serverUrl = this.getServerStringFromUrl(DEFAULT_AUTH_ENDPOINT_URL);
        }
        UIUtils.validateHttpsUrlAndThrow(serverUrl);
        return serverUrl;
    }

    public DescribeSObjectResult describeSObject(String entity) throws ConnectionException {
        DescribeSObjectResult result = this.getEntityDescribeMap().get(entity);
        if (result == null && (result = this.runOperation(this.DESCRIBE_SOBJECT_OPERATION, entity)) != null) {
            this.getEntityDescribeMap().put(result.getName(), result);
        }
        return result;
    }

    private boolean checkConnectionException(ConnectionException ex, String operationName, int retryNum) {
        if (!this.enableRetries) {
            return false;
        }
        String msg = ex.getMessage();
        if (msg != null && msg.toLowerCase().indexOf("connection reset") >= 0) {
            this.retrySleep(operationName, retryNum);
            return true;
        }
        return false;
    }

    public Field getField(String apiName) {
        Field field = this.fieldsByName.get(apiName = apiName.toLowerCase());
        if (field == null) {
            field = this.lookupField(apiName);
            this.fieldsByName.put(apiName, field);
        }
        return field;
    }

    private Field lookupField(String apiName) {
        for (Field f : this.getFieldTypes().getFields()) {
            if (!apiName.equals(f.getName().toLowerCase()) && !apiName.equals(f.getLabel().toLowerCase())) continue;
            return f;
        }
        if (apiName.contains(":")) {
            Map<String, DescribeRefObject> refs = this.getReferenceDescribes();
            for (Map.Entry<String, DescribeRefObject> ent : refs.entrySet()) {
                String relName = ent.getKey().toLowerCase();
                if (!apiName.startsWith(relName)) continue;
                for (Map.Entry<String, Field> refEntry : ent.getValue().getFieldInfoMap().entrySet()) {
                    String thisRefName = relName + ":" + refEntry.getKey().toLowerCase();
                    if (!apiName.equals(thisRefName)) continue;
                    return refEntry.getValue();
                }
            }
        }
        return null;
    }

    private static interface ClientOperation<RESULT, ARG> {
        public String getName();

        public RESULT run(ARG var1) throws ConnectionException;
    }
}

