/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.client;

import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.tools.VersionInfo;
import com.sforce.ws.transport.LimitingOutputStream;
import com.sforce.ws.transport.MessageHandlerOutputStream;
import com.sforce.ws.transport.Transport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpClientTransport
implements Transport {
    private ConnectorConfig config;
    private boolean successful;
    private HttpPost post;
    private OutputStream output;
    private ByteArrayOutputStream entityByteOut;

    public HttpClientTransport() {
    }

    public HttpClientTransport(ConnectorConfig config) {
        this.setConfig(config);
    }

    @Override
    public void setConfig(ConnectorConfig config) {
        this.config = config;
    }

    @Override
    public OutputStream connect(String url, String soapAction) throws IOException {
        if (soapAction == null) {
            soapAction = "";
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("SOAPAction", "\"" + soapAction + "\"");
        header.put("Content-Type", "text/xml; charset=UTF-8");
        header.put("Accept", "text/xml");
        return this.connect(url, header);
    }

    @Override
    public InputStream getContent() throws IOException {
        InputStream input;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.config.getProxy().address() != null) {
            Credentials credentials;
            String proxyPassword;
            String proxyUser = this.config.getProxyUsername() == null ? "" : this.config.getProxyUsername();
            String string = proxyPassword = this.config.getProxyPassword() == null ? "" : this.config.getProxyPassword();
            if (this.config.getNtlmDomain() != null && !this.config.getNtlmDomain().equals("")) {
                String computerName = InetAddress.getLocalHost().getCanonicalHostName();
                credentials = new NTCredentials(proxyUser, proxyPassword, computerName, this.config.getNtlmDomain());
            } else {
                credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)this.config.getProxy().address();
            HttpHost proxyHost = new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort(), "http");
            httpClientBuilder.setProxy(proxyHost);
            BasicCredentialsProvider credentialsprovider = new BasicCredentialsProvider();
            AuthScope scope = new AuthScope(proxyAddress.getHostName(), proxyAddress.getPort(), null, null);
            credentialsprovider.setCredentials(scope, credentials);
            httpClientBuilder.setDefaultCredentialsProvider(credentialsprovider);
        }
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            CloseableHttpResponse ignored;
            byte[] entityBytes = this.entityByteOut.toByteArray();
            ByteArrayEntity entity = new ByteArrayEntity(entityBytes);
            this.post.setEntity(entity);
            if (this.config.getNtlmDomain() != null && !this.config.getNtlmDomain().equals("") && (ignored = httpClient.execute(new HttpHead("http://salesforce.com"))) != null) {
                ignored.close();
            }
            try (CloseableHttpResponse response = httpClient.execute(this.post);){
                this.successful = true;
                if (response.getStatusLine().getStatusCode() > 399) {
                    this.successful = false;
                    if (response.getStatusLine().getStatusCode() == 407) {
                        throw new RuntimeException(response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                    }
                }
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                try (InputStream inStream = response.getEntity().getContent();){
                    IOUtils.copy(inStream, (OutputStream)bOut);
                    input = new ByteArrayInputStream(bOut.toByteArray());
                    if (response.containsHeader("Content-Encoding") && response.getHeaders("Content-Encoding")[0].getValue().equals("gzip")) {
                        input = new GZIPInputStream(input);
                    }
                }
            }
        }
        return input;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public OutputStream connect(String endpoint, HashMap<String, String> httpHeaders) throws IOException {
        return this.connect(endpoint, httpHeaders, true);
    }

    @Override
    public OutputStream connect(String endpoint, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        this.post = new HttpPost(endpoint);
        for (String name : httpHeaders.keySet()) {
            this.post.addHeader(name, httpHeaders.get(name));
        }
        this.post.addHeader("User-Agent", VersionInfo.info());
        if (enableCompression) {
            this.post.addHeader("Content-Encoding", "gzip");
            this.post.addHeader("Accept-Encoding", "gzip");
        }
        this.entityByteOut = new ByteArrayOutputStream();
        this.output = this.entityByteOut;
        if (this.config.getMaxRequestSize() > 0) {
            this.output = new LimitingOutputStream(this.config.getMaxRequestSize(), this.output);
        }
        if (enableCompression && this.config.isCompression()) {
            this.output = new GZIPOutputStream(this.output);
        }
        if (this.config.isTraceMessage()) {
            this.output = this.config.teeOutputStream(this.output);
        }
        if (this.config.hasMessageHandlers()) {
            URL url = new URL(endpoint);
            this.output = new MessageHandlerOutputStream(this.config, url, this.output);
        }
        return this.output;
    }
}

