/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.client;

import com.salesforce.dataloader.client.SimplePost;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.sforce.ws.tools.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class DefaultSimplePost
implements SimplePost {
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private boolean successful;
    private Config config;
    private String endpoint;
    private BasicNameValuePair[] pairs;
    private InputStream input;
    private int statusCode;
    private String reasonPhrase;

    DefaultSimplePost(Config config, String endpoint, BasicNameValuePair ... pairs) {
        this.config = config;
        this.endpoint = endpoint;
        this.pairs = pairs;
    }

    @Override
    public void post() throws IOException, ParameterLoadException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        HttpPost post = new HttpPost(this.endpoint);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(Arrays.asList(this.pairs));
        int proxyPort = this.config.getInt("sfdc.proxyPort");
        String proxyHostName = this.config.getString("sfdc.proxyHost");
        String proxyUser = this.config.getString("sfdc.proxyUsername");
        String proxyPassword = this.config.getString("sfdc.proxyPassword");
        String ntlmDomain = this.config.getString("sfdc.proxyNtlmDomain");
        proxyHostName = proxyHostName != null ? proxyHostName.trim() : "";
        proxyUser = proxyUser != null ? proxyUser.trim() : "";
        proxyPassword = proxyPassword != null ? proxyPassword.trim() : "";
        ntlmDomain = ntlmDomain != null ? ntlmDomain.trim() : "";
        post.addHeader("User-Agent", VersionInfo.info());
        post.setEntity(entity);
        if (proxyHostName.length() > 0) {
            InetSocketAddress proxyAddress = new InetSocketAddress(proxyHostName, proxyPort);
            HttpHost proxyHost = new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort(), "http");
            AuthScope scope = new AuthScope(proxyAddress.getHostName(), proxyAddress.getPort(), null, null);
            Credentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            if (ntlmDomain.length() > 0) {
                credentials = new NTCredentials(proxyUser, proxyPassword, InetAddress.getLocalHost().getCanonicalHostName(), ntlmDomain);
            }
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            requestConfigBuilder.setProxy(proxyHost);
            post.setConfig(requestConfigBuilder.build());
            BasicCredentialsProvider credentialsprovider = new BasicCredentialsProvider();
            credentialsprovider.setCredentials(scope, credentials);
            httpClientBuilder.setDefaultCredentialsProvider(credentialsprovider).build();
        }
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            HttpHead head;
            CloseableHttpResponse ignored;
            if (ntlmDomain.length() > 0 && (ignored = httpClient.execute(head = new HttpHead("http://salesforce.com"))) != null) {
                ignored.close();
            }
            try (CloseableHttpResponse response = httpClient.execute(post);){
                this.successful = response.getStatusLine().getStatusCode() < 400;
                this.statusCode = response.getStatusLine().getStatusCode();
                this.reasonPhrase = response.getStatusLine().getReasonPhrase();
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                try (InputStream inStream = response.getEntity().getContent();){
                    IOUtils.copy(inStream, (OutputStream)bOut);
                    this.input = new ByteArrayInputStream(bOut.toByteArray());
                    if (response.containsHeader("Content-Encoding") && response.getHeaders("Content-Encoding")[0].getValue().equals("gzip")) {
                        this.input = new GZIPInputStream(this.input);
                    }
                }
            }
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public InputStream getInput() {
        return this.input;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getReasonPhrase() {
        return this.reasonPhrase;
    }
}

