/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.client;

import com.salesforce.dataloader.client.HttpClientTransport;
import com.salesforce.dataloader.client.PartnerClient;
import com.salesforce.dataloader.client.SessionInfo;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.sforce.ws.ConnectorConfig;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public abstract class ClientBase<ClientType> {
    private static Logger LOG;
    protected static final URL DEFAULT_AUTH_ENDPOINT_URL;
    public static final String REST_ENDPOINT;
    protected final Logger logger;
    protected final Controller controller;
    protected final Config config;
    private SessionInfo session = new SessionInfo();
    private static final String BASE_CLIENT_NAME = "DataLoader";
    private static final String BULK_API_CLIENT_TYPE = "Bulk";
    private static final String PARTNER_API_CLIENT_TYPE = "Partner";
    private static final String BATCH_CLIENT_STRING = "Batch";
    private static final String UI_CLIENT_STRING = "UI";

    protected abstract boolean connectPostLogin(ConnectorConfig var1);

    public abstract ClientType getClient();

    protected ClientBase(Controller controller, Logger logger) {
        this.controller = controller;
        this.config = controller.getConfig();
        this.logger = logger;
    }

    public final boolean connect(SessionInfo sess) {
        this.setSession(sess);
        return this.connectPostLogin(this.getConnectorConfig());
    }

    protected static String getClientName(Config cfg) {
        String apiType = cfg.isBulkAPIEnabled() ? BULK_API_CLIENT_TYPE : PARTNER_API_CLIENT_TYPE;
        String interfaceType = cfg.isBatchMode() ? BATCH_CLIENT_STRING : UI_CLIENT_STRING;
        return new StringBuilder(32).append(BASE_CLIENT_NAME).append(apiType).append(interfaceType).append("/").append(Controller.API_VERSION).toString();
    }

    protected ConnectorConfig getConnectorConfig() {
        String server;
        int timeoutSecs;
        int connTimeoutSecs;
        boolean isOAuthSession;
        ConnectorConfig cc = new ConnectorConfig();
        cc.setTransport(HttpClientTransport.class);
        cc.setSessionId(this.getSessionId());
        String username = this.config.getString("sfdc.username");
        boolean isManualSession = this.config.getBoolean("sfdcInternal") && this.config.getBoolean("sfdcInternal.isSessionIdLogin");
        boolean bl = isOAuthSession = this.config.getString("sfdc.oauth.accesstoken") != null && this.config.getString("sfdc.oauth.accesstoken").trim().length() > 0;
        if (!(isManualSession || isOAuthSession || username != null && username.length() != 0)) {
            String errMsg = Messages.getMessage(this.getClass(), "emptyUsername", "sfdc.username");
            this.logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        cc.setUsername(username);
        cc.setPassword(this.config.getString("sfdc.password"));
        try {
            String proxyHost = this.config.getString("sfdc.proxyHost");
            int proxyPort = this.config.getInt("sfdc.proxyPort");
            if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
                String proxyNtlmDomain;
                this.logger.info(Messages.getFormattedString("Client.sforceLoginProxyDetail", new String[]{proxyHost, String.valueOf(proxyPort)}));
                cc.setProxy(proxyHost, proxyPort);
                String proxyUsername = this.config.getString("sfdc.proxyUsername");
                if (proxyUsername != null && proxyUsername.length() > 0) {
                    this.logger.info(Messages.getFormattedString("Client.sforceLoginProxyUser", proxyUsername));
                    cc.setProxyUsername(proxyUsername);
                    String proxyPassword = this.config.getString("sfdc.proxyPassword");
                    if (proxyPassword != null && proxyPassword.length() > 0) {
                        this.logger.info(Messages.getString("Client.sforceLoginProxyPassword", new Object[0]));
                        cc.setProxyPassword(proxyPassword);
                    } else {
                        cc.setProxyPassword("");
                    }
                }
                if ((proxyNtlmDomain = this.config.getString("sfdc.proxyNtlmDomain")) != null && proxyNtlmDomain.length() > 0) {
                    this.logger.info(Messages.getFormattedString("Client.sforceLoginProxyNtlm", proxyNtlmDomain));
                    cc.setNtlmDomain(proxyNtlmDomain);
                }
            }
        }
        catch (ParameterLoadException e) {
            this.logger.error(e.getMessage());
        }
        try {
            connTimeoutSecs = this.config.getInt("sfdc.connectionTimeoutSecs");
        }
        catch (ParameterLoadException e1) {
            connTimeoutSecs = 60;
        }
        cc.setConnectionTimeout(connTimeoutSecs * 1000);
        try {
            timeoutSecs = this.config.getInt("sfdc.timeoutSecs");
        }
        catch (ParameterLoadException e) {
            timeoutSecs = 540;
        }
        cc.setReadTimeout(timeoutSecs * 1000);
        if (this.config.contains("sfdc.noCompression")) {
            cc.setCompression(!this.config.getBoolean("sfdc.noCompression"));
        }
        if (this.config.getBoolean("sfdc.debugMessages")) {
            cc.setTraceMessage(true);
            cc.setPrettyPrintXml(true);
            String filename = this.config.getString("sfdc.debugMessagesFile");
            if (filename.length() > 0) {
                try {
                    cc.setTraceFile(filename);
                }
                catch (FileNotFoundException e) {
                    this.logger.warn(Messages.getFormattedString("Client.errorMsgDebugFilename", filename));
                }
            }
        }
        if ((server = this.getSession().getServer()) != null) {
            cc.setAuthEndpoint(server + DEFAULT_AUTH_ENDPOINT_URL.getPath());
            cc.setServiceEndpoint(server + DEFAULT_AUTH_ENDPOINT_URL.getPath());
            cc.setRestEndpoint(server + REST_ENDPOINT);
        }
        return cc;
    }

    public SessionInfo getSession() {
        return this.session;
    }

    protected void clearSession() {
        this.setSession(new SessionInfo());
    }

    protected void setSession(String sessionId, String server) {
        this.setSession(new SessionInfo(sessionId, server));
    }

    private void setSession(SessionInfo sess) {
        this.session = sess;
    }

    protected String getSessionId() throws SessionInfo.NotLoggedInException {
        return this.getSession().getSessionId();
    }

    static {
        URL loginUrl;
        LOG = Logger.getLogger(PartnerClient.class);
        try {
            loginUrl = new URL("http://rpolk-ltm3.internal.salesforce.com:6109/services/Soap/u/45.0");
        }
        catch (MalformedURLException ex) {
            LOG.error(ex);
            throw new RuntimeException(ex);
        }
        DEFAULT_AUTH_ENDPOINT_URL = loginUrl;
        REST_ENDPOINT = "/services/async/" + Controller.API_VERSION;
    }
}

