/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.client;

import com.salesforce.dataloader.client.ClientBase;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import com.sforce.ws.ConnectorConfig;
import org.apache.log4j.Logger;

public class BulkClient
extends ClientBase<BulkConnection> {
    private static Logger LOG = Logger.getLogger(BulkClient.class);
    private BulkConnection client;

    public BulkClient(Controller controller) {
        super(controller, LOG);
    }

    @Override
    public BulkConnection getClient() {
        return this.client;
    }

    @Override
    protected boolean connectPostLogin(ConnectorConfig cc) {
        try {
            this.client = new BulkConnection(cc);
        }
        catch (AsyncApiException e) {
            this.logger.error(Messages.getMessage(this.getClass(), "loginError", cc.getAuthEndpoint(), e.getExceptionMessage()), e);
            throw new RuntimeException(e.getExceptionMessage(), e);
        }
        return true;
    }

    @Override
    protected ConnectorConfig getConnectorConfig() {
        ConnectorConfig cc = super.getConnectorConfig();
        cc.setTraceMessage(this.config.getBoolean("sfdc.wireOutput"));
        return cc;
    }
}

