/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.AbstractQueryVisitor;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.model.Row;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class PartnerQueryVisitor
extends AbstractQueryVisitor {
    private QueryResult qr;
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public PartnerQueryVisitor(Controller controller, ILoaderProgress monitor, DataWriter queryWriter, DataWriter successWriter, DataWriter errorWriter) {
        super(controller, monitor, queryWriter, successWriter, errorWriter);
    }

    @Override
    protected int executeQuery(String soql) throws ConnectionException {
        this.qr = this.getQueryResult(soql);
        return this.qr.getSize();
    }

    protected QueryResult getQueryResult(String soql) throws ConnectionException {
        return this.getController().getPartnerClient().query(soql);
    }

    @Override
    protected void writeExtraction() throws DataAccessObjectException, ConnectionException {
        while (this.qr.getRecords() != null) {
            SObject[] sfdcResults = this.qr.getRecords();
            if (sfdcResults == null) {
                this.getLogger().error(Messages.getMessage(this.getClass(), "errorNoResults", new Object[0]));
                return;
            }
            for (int i = 0; i < sfdcResults.length; ++i) {
                this.addResultRow(this.getDaoRow(sfdcResults[i]), sfdcResults[i].getId());
            }
            if (this.qr.getDone()) break;
            if (this.getProgressMonitor().isCanceled()) {
                return;
            }
            this.qr = this.getController().getPartnerClient().queryMore(this.qr.getQueryLocator());
        }
    }

    private Row getDaoRow(SObject sob) {
        Row row = this.getMapper().mapPartnerSObjectSfdcToLocal(sob);
        for (Map.Entry<String, Object> ent : row.entrySet()) {
            Object newVal = this.convertFieldValue(ent.getValue());
            if (newVal == ent.getValue()) continue;
            row.put(ent.getKey(), newVal);
        }
        return row;
    }

    private Object convertFieldValue(Object fieldVal) {
        if (fieldVal instanceof Calendar) {
            DF.setCalendar((Calendar)fieldVal);
            return DF.format(((Calendar)fieldVal).getTime());
        }
        if (fieldVal instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df.format((Date)fieldVal);
        }
        return fieldVal;
    }
}

