/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.DAOLoadVisitor;
import com.salesforce.dataloader.client.PartnerClient;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.LoadException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.model.Row;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.ws.ConnectionException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;

public abstract class PartnerLoadVisitor
extends DAOLoadVisitor {
    public PartnerLoadVisitor(Controller controller, ILoaderProgress monitor, DataWriter successWriter, DataWriter errorWriter) {
        super(controller, monitor, successWriter, errorWriter);
    }

    @Override
    protected void loadBatch() throws DataAccessObjectException, LoadException {
        int currentProcessed;
        Object[] results = null;
        try {
            results = this.executeClientAction(this.getController().getPartnerClient(), this.dynaArray);
        }
        catch (ApiFault e) {
            this.handleException(e);
        }
        catch (ConnectionException e) {
            this.handleException(e);
        }
        try {
            currentProcessed = this.getConfig().getInt("process.lastLoadBatchRow");
        }
        catch (ParameterLoadException e) {
            currentProcessed = 0;
        }
        this.getConfig().setValue("process.lastLoadBatchRow", currentProcessed += results.length);
        try {
            this.getConfig().saveLastRun();
        }
        catch (IOException e) {
            String errMsg = Messages.getString("LoadAction.errorLastRun", new Object[0]);
            this.getLogger().error(errMsg, e);
            this.handleException(errMsg, e);
        }
        this.writeOutputToWriter(results, this.dataArray);
        this.getProgressMonitor().worked(results.length);
        this.getProgressMonitor().setSubTask(this.getRateCalculator().calculateSubTask(this.getNumberOfRows(), this.getNumberErrors()));
        this.clearArrays();
    }

    private void writeOutputToWriter(Object[] results, List<Row> dataArray) throws DataAccessObjectException, LoadException {
        if (results.length != dataArray.size()) {
            this.getLogger().fatal(Messages.getString("Visitor.errorResultsLength", new Object[0]));
            throw new LoadException(Messages.getString("Visitor.errorResultsLength", new Object[0]));
        }
        for (int i = 0; i < results.length; ++i) {
            Row dataRow = dataArray.get(i);
            String statusMsg = null;
            if (results instanceof SaveResult[]) {
                SaveResult saveRes = (SaveResult)results[i];
                if (saveRes.getSuccess()) {
                    statusMsg = OperationInfo.insert == this.getConfig().getOperationInfo() ? Messages.getString("DAOLoadVisitor.statusItemCreated", new Object[0]) : Messages.getString("DAOLoadVisitor.statusItemUpdated", new Object[0]);
                }
                dataRow.put("STATUS", (Object)statusMsg);
                this.processResult(dataRow, saveRes.getSuccess(), saveRes.getId(), saveRes.getErrors());
                continue;
            }
            if (results instanceof DeleteResult[]) {
                DeleteResult deleteRes = (DeleteResult)results[i];
                if (deleteRes.getSuccess()) {
                    statusMsg = Messages.getString("DAOLoadVisitor.statusItemDeleted", new Object[0]);
                }
                dataRow.put("STATUS", (Object)statusMsg);
                this.processResult(dataRow, deleteRes.getSuccess(), deleteRes.getId(), deleteRes.getErrors());
                continue;
            }
            if (!(results instanceof UpsertResult[])) continue;
            UpsertResult upsertRes = (UpsertResult)results[i];
            if (upsertRes.getSuccess()) {
                statusMsg = upsertRes.getCreated() ? Messages.getString("DAOLoadVisitor.statusItemCreated", new Object[0]) : Messages.getString("DAOLoadVisitor.statusItemUpdated", new Object[0]);
            }
            dataRow.put("STATUS", (Object)statusMsg);
            this.processResult(dataRow, upsertRes.getSuccess(), upsertRes.getId(), upsertRes.getErrors());
        }
    }

    private void processResult(Row dataRow, boolean isSuccess, String id, Error[] errors) throws DataAccessObjectException {
        if (isSuccess) {
            this.writeSuccess(dataRow, id, null);
        } else {
            this.writeError(dataRow, errors == null ? Messages.getString("Visitor.noErrorReceivedMsg", new Object[0]) : errors[0].getMessage());
        }
    }

    protected abstract Object[] executeClientAction(PartnerClient var1, List<DynaBean> var2) throws ConnectionException;
}

