/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.AbstractVisitor;
import com.salesforce.dataloader.action.visitor.DAORowVisitor;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataReader;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.dyna.SforceDynaBean;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.LoadException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.mapping.LoadMapper;
import com.salesforce.dataloader.model.Row;
import com.sforce.async.AsyncApiException;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.ws.ConnectionException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;

public abstract class DAOLoadVisitor
extends AbstractVisitor
implements DAORowVisitor {
    protected final List<String> columnNames;
    protected final List<DynaBean> dynaArray;
    protected final List<Row> dataArray;
    protected final BasicDynaClass dynaClass;
    protected final DynaProperty[] dynaProps;
    private final int batchSize;

    protected DAOLoadVisitor(Controller controller, ILoaderProgress monitor, DataWriter successWriter, DataWriter errorWriter) {
        super(controller, monitor, successWriter, errorWriter);
        this.columnNames = ((DataReader)controller.getDao()).getColumnNames();
        this.dynaArray = new LinkedList<DynaBean>();
        this.dataArray = new LinkedList<Row>();
        SforceDynaBean.registerConverters(this.getConfig());
        this.dynaProps = SforceDynaBean.createDynaProps(controller.getFieldTypes(), controller);
        this.dynaClass = SforceDynaBean.getDynaBeanInstance(this.dynaProps);
        this.batchSize = this.getConfig().getLoadBatchSize();
    }

    @Override
    public final void visit(Row row) throws OperationException, DataAccessObjectException, ConnectionException {
        this.initLoadRateCalculator();
        Row sforceDataRow = this.getMapper().mapData(row);
        try {
            this.convertBulkAPINulls(sforceDataRow);
            this.dynaArray.add(SforceDynaBean.convertToDynaBean(this.dynaClass, sforceDataRow));
        }
        catch (ConversionException conve) {
            String errMsg = Messages.getMessage("Visitor", "conversionErrorMsg", conve.getMessage());
            this.getLogger().error(errMsg, conve);
            this.conversionFailed(row, errMsg);
            return;
        }
        this.dataArray.add(row);
        if (this.dynaArray.size() >= this.batchSize) {
            this.loadBatch();
        }
    }

    protected void conversionFailed(Row row, String errMsg) throws DataAccessObjectException, OperationException {
        this.writeError(row, errMsg);
    }

    protected void convertBulkAPINulls(Row row) {
    }

    public void flushRemaining() throws OperationException, DataAccessObjectException {
        if (this.dynaArray.size() > 0) {
            this.loadBatch();
        }
    }

    protected abstract void loadBatch() throws DataAccessObjectException, OperationException;

    public void clearArrays() {
        this.dataArray.clear();
        this.dynaArray.clear();
    }

    protected void handleException(String msgOverride, Throwable t) throws LoadException {
        String msg = msgOverride;
        if (msg == null) {
            msg = t.getMessage();
            if (t instanceof AsyncApiException) {
                msg = ((AsyncApiException)t).getExceptionMessage();
            } else if (t instanceof ApiFault) {
                msg = ((ApiFault)t).getExceptionMessage();
            }
        }
        throw new LoadException(msg, t);
    }

    protected void handleException(Throwable t) throws LoadException {
        this.handleException(null, t);
    }

    @Override
    protected boolean writeStatus() {
        return true;
    }

    private void initLoadRateCalculator() throws DataAccessObjectException {
        this.getRateCalculator().setNumRecords(((DataReader)this.getController().getDao()).getTotalRows());
        this.getRateCalculator().start();
    }

    @Override
    protected LoadMapper getMapper() {
        return (LoadMapper)super.getMapper();
    }
}

