/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.AbstractQueryVisitor;
import com.salesforce.dataloader.action.visitor.BulkApiVisitorUtil;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.ExtractException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.model.Row;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.CSVReader;
import com.sforce.async.QueryResultList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class BulkQueryVisitor
extends AbstractQueryVisitor {
    private BatchInfo batch;

    public BulkQueryVisitor(Controller controller, ILoaderProgress monitor, DataWriter queryWriter, DataWriter successWriter, DataWriter errorWriter) {
        super(controller, monitor, queryWriter, successWriter, errorWriter);
    }

    @Override
    protected int executeQuery(String soql) throws AsyncApiException, OperationException {
        BulkApiVisitorUtil jobUtil = new BulkApiVisitorUtil(this.getController(), this.getProgressMonitor(), this.getRateCalculator(), false);
        jobUtil.createJob(this.getConfig());
        try {
            jobUtil.createBatch(new ByteArrayInputStream(soql.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new ExtractException(e);
        }
        jobUtil.closeJob();
        BatchInfo b = jobUtil.getBatches().getBatchInfo()[0];
        if (b.getState() == BatchStateEnum.Failed) {
            throw new ExtractException("Batch failed: " + b.getStateMessage());
        }
        this.batch = b;
        return b.getNumberRecordsProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeExtraction() throws AsyncApiException, ExtractException, DataAccessObjectException {
        if (this.batch.getState() == BatchStateEnum.Failed) {
            throw new ExtractException("Batch failed: " + this.batch.getStateMessage());
        }
        QueryResultList results = this.getController().getBulkClient().getClient().getQueryResultList(this.batch.getJobId(), this.batch.getId());
        for (String resultId : results.getResult()) {
            if (this.getProgressMonitor().isCanceled()) {
                return;
            }
            try (InputStream resultStream = this.getController().getBulkClient().getClient().getQueryResultStream(this.batch.getJobId(), this.batch.getId(), resultId);){
                ArrayList<String> csvRow;
                CSVReader rdr = new CSVReader(resultStream, "UTF-8");
                rdr.setMaxCharsInFile(Integer.MAX_VALUE);
                rdr.setMaxRowsInFile(Integer.MAX_VALUE);
                ArrayList<String> headers = rdr.nextRecord();
                while ((csvRow = rdr.nextRecord()) != null) {
                    StringBuilder id = new StringBuilder();
                    Row daoRow = this.getDaoRow(headers, csvRow, id);
                    this.addResultRow(daoRow, id.toString());
                }
            }
            catch (IOException e) {
                throw new ExtractException(e);
            }
        }
    }

    private Row getDaoRow(List<String> headers, List<String> csvRow, StringBuilder id) {
        return this.getMapper().mapCsvRowSfdcToLocal(headers, csvRow, id);
    }
}

