/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.BulkApiVisitorUtil;
import com.salesforce.dataloader.action.visitor.DAOLoadVisitor;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataReader;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.LoadException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.model.NACalendarValue;
import com.salesforce.dataloader.model.NATextValue;
import com.salesforce.dataloader.model.Row;
import com.salesforce.dataloader.util.DAORowUtil;
import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.CSVReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.log4j.Logger;

public class BulkLoadVisitor
extends DAOLoadVisitor {
    private static final Logger logger = Logger.getLogger(BulkLoadVisitor.class);
    private static final String SUCCESS_RESULT_COL = "Success";
    private static final String ERROR_RESULT_COL = "Error";
    private static final String ID_RESULT_COL = "Id";
    private static final String CREATED_RESULT_COL = "Created";
    private static final String SKIP_BATCH_ID = "SKIP";
    private final boolean isDelete;
    private static final DateFormat DATE_FMT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final BulkApiVisitorUtil jobUtil;
    private final List<BatchData> allBatchesInOrder = new ArrayList<BatchData>();

    public BulkLoadVisitor(Controller controller, ILoaderProgress monitor, DataWriter successWriter, DataWriter errorWriter) {
        super(controller, monitor, successWriter, errorWriter);
        this.isDelete = this.getController().getConfig().getOperationInfo().isDelete();
        this.jobUtil = new BulkApiVisitorUtil(this.getController(), this.getProgressMonitor(), this.getRateCalculator());
    }

    @Override
    protected void loadBatch() throws DataAccessObjectException, OperationException {
        try {
            if (!this.jobUtil.hasJob()) {
                this.jobUtil.createJob(this.getConfig());
            }
            this.createBatches();
            this.clearArrays();
        }
        catch (AsyncApiException e) {
            this.handleException(e);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    @Override
    protected void handleException(Throwable t) throws LoadException {
        this.handleException(this.getOverrideMessage(t), t);
    }

    private String getOverrideMessage(Throwable t) {
        if (t instanceof AsyncApiException) {
            AsyncApiException aae = (AsyncApiException)t;
            String hardDeleteNoPermsMessage = "hardDelete operation requires special user profile permission, please contact your system administrator";
            if (aae.getExceptionCode() == AsyncExceptionCode.FeatureNotEnabled && aae.getExceptionMessage().contains("hardDelete operation requires special user profile permission, please contact your system administrator")) {
                return Messages.getMessage(this.getClass(), "hardDeleteNoPerm", new Object[0]);
            }
        }
        return null;
    }

    private void createBatches() throws OperationException, IOException, AsyncApiException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)os, true, "UTF-8");
        this.doOneBatch(out, os, this.dynaArray);
    }

    private void doOneBatch(PrintStream out, ByteArrayOutputStream os, List<DynaBean> rows) throws OperationException, AsyncApiException {
        int recordsInBatch = 0;
        List<String> userColumns = this.getController().getDao().getColumnNames();
        List<String> headerColumns = null;
        for (int i = 0; i < rows.size(); ++i) {
            DynaBean row = rows.get(i);
            if (recordsInBatch == 0) {
                headerColumns = this.addHeader(out, os, row, userColumns);
            }
            this.writeRow(row, out, os, recordsInBatch, headerColumns);
            ++recordsInBatch;
            if (os.size() <= 10000000) continue;
            this.createBatch(os, recordsInBatch);
            recordsInBatch = 0;
        }
        if (recordsInBatch > 0) {
            this.createBatch(os, recordsInBatch);
        }
        this.jobUtil.periodicCheckStatus();
    }

    private void writeRow(DynaBean row, PrintStream out, ByteArrayOutputStream os, int recordsInBatch, List<String> header) throws LoadException {
        boolean notFirst = false;
        for (String column : header) {
            if (notFirst) {
                out.print(',');
            } else {
                notFirst = true;
            }
            this.writeSingleColumn(out, column, row.get(column));
        }
        out.println();
    }

    private void writeSingleColumn(PrintStream out, String fieldName, Object fieldValue) throws LoadException {
        if (fieldValue != null) {
            Object col = fieldValue;
            if (fieldValue instanceof NACalendarValue) {
                col = fieldValue.toString();
            } else if (fieldValue instanceof Calendar) {
                col = DATE_FMT.format(((Calendar)fieldValue).getTime());
            } else if (fieldValue instanceof byte[]) {
                if (!this.getController().attachmentsEnabled()) {
                    throw new LoadException(Messages.getMessage("FinishPage", "cannotMapBase64ForBulkApi", fieldName));
                }
                col = this.jobUtil.addAttachment((byte[])fieldValue);
            }
            this.writeColumnToCsv(out, col);
        } else {
            this.getLogger().warn(Messages.getMessage(this.getClass(), "noFieldVal", fieldName));
        }
    }

    private void writeColumnToCsv(PrintStream out, Object val) {
        out.print('\"');
        out.print(val.toString().replace("\"", "\"\""));
        out.print('\"');
    }

    private List<String> addHeader(PrintStream out, ByteArrayOutputStream os, DynaBean row, List<String> columns) throws LoadException {
        boolean first = true;
        ArrayList<String> cols = new ArrayList<String>();
        TreeSet<String> addedCols = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String userColumn : columns) {
            String sfdcColumn = this.getMapper().getMapping(userColumn);
            if (sfdcColumn == null || sfdcColumn.length() == 0) {
                this.getLogger().warn("Cannot find mapping for column: " + userColumn + ".  Omitting column");
                continue;
            }
            if (!(!this.isDelete || first && "id".equalsIgnoreCase(sfdcColumn))) {
                throw new LoadException(Messages.getMessage(this.getClass(), "deleteCsvError", new Object[0]));
            }
            BulkLoadVisitor.addFieldToHeader(out, sfdcColumn, cols, addedCols, first);
            if (!first) continue;
            first = false;
        }
        for (DynaProperty dynaProperty : row.getDynaClass().getDynaProperties()) {
            String name = dynaProperty.getName();
            if (row.get(name) == null || addedCols.contains(name)) continue;
            BulkLoadVisitor.addFieldToHeader(out, name, cols, addedCols, first);
        }
        out.println();
        return Collections.unmodifiableList(cols);
    }

    private static void addFieldToHeader(PrintStream out, String sfdcColumn, List<String> cols, Set<String> addedCols, boolean first) {
        if (!first) {
            out.print(',');
        }
        out.print(sfdcColumn.replace(':', '.'));
        cols.add(sfdcColumn);
        addedCols.add(sfdcColumn);
    }

    private void createBatch(ByteArrayOutputStream os, int numRecords) throws AsyncApiException {
        if (numRecords <= 0) {
            return;
        }
        byte[] request = os.toByteArray();
        os.reset();
        BatchInfo bi = this.jobUtil.createBatch(new ByteArrayInputStream(request, 0, request.length));
        this.allBatchesInOrder.add(new BatchData(bi.getId(), numRecords));
    }

    @Override
    public void flushRemaining() throws OperationException, DataAccessObjectException {
        super.flushRemaining();
        if (this.jobUtil.hasJob()) {
            try {
                this.jobUtil.closeJob();
            }
            catch (AsyncApiException e) {
                logger.warn("Failed to close job", e);
            }
            try {
                this.getResults();
            }
            catch (AsyncApiException e) {
                throw new LoadException("Failed to get batch results", e);
            }
        }
    }

    private void getResults() throws AsyncApiException, OperationException, DataAccessObjectException {
        this.getProgressMonitor().setSubTask(Messages.getMessage(this.getClass(), "retrievingResults", new Object[0]));
        DataReader dataReader = this.resetDAO();
        Map<String, BatchInfo> batchInfoMap = this.createBatchInfoMap();
        for (BatchData clientBatchInfo : this.allBatchesInOrder) {
            if (clientBatchInfo.batchId == SKIP_BATCH_ID) {
                this.skipDataRows(dataReader, clientBatchInfo.numRows);
                continue;
            }
            this.processResults(dataReader, batchInfoMap.get(clientBatchInfo.batchId), clientBatchInfo);
        }
    }

    private void processResults(DataReader dataReader, BatchInfo batch, BatchData clientBatchInfo) throws LoadException, DataAccessObjectException, AsyncApiException {
        this.sanityCheckBatch(clientBatchInfo, batch);
        String stateMessage = batch.getState() == BatchStateEnum.Completed ? null : batch.getStateMessage();
        String errorMessage = stateMessage == null ? null : Messages.getMessage(this.getClass(), "batchError", stateMessage);
        List<Row> rows = dataReader.readRowList(clientBatchInfo.numRows);
        if (batch.getState() == BatchStateEnum.Completed || batch.getNumberRecordsProcessed() > 0) {
            try {
                this.processBatchResults(batch, errorMessage, batch.getState(), rows);
            }
            catch (IOException e) {
                throw new LoadException("IOException while reading batch results", e);
            }
        } else {
            for (Row row : rows) {
                this.writeError(row, errorMessage);
            }
        }
    }

    private void skipDataRows(DataReader dataReader, int numRows) throws DataAccessObjectException {
        List<Row> skippedRows = dataReader.readRowList(numRows);
        assert (skippedRows.size() == numRows);
    }

    private void processBatchResults(BatchInfo batch, String errorMessage, BatchStateEnum state, List<Row> rows) throws DataAccessObjectException, IOException, AsyncApiException {
        CSVReader resultRdr = this.jobUtil.getBatchResults(batch.getId());
        Map<String, Integer> hdrIndices = this.mapHeaderIndices(resultRdr.nextRecord());
        int successIdx = hdrIndices.get(SUCCESS_RESULT_COL);
        int createdIdx = this.isDelete ? -1 : hdrIndices.get(CREATED_RESULT_COL);
        int idIdx = hdrIndices.get(ID_RESULT_COL);
        int errIdx = hdrIndices.get(ERROR_RESULT_COL);
        hdrIndices = null;
        for (Row row : rows) {
            ArrayList<String> res = resultRdr.nextRecord();
            if (state == BatchStateEnum.Failed || errorMessage != null) {
                this.getLogger().warn(Messages.getMessage(this.getClass(), "logBatchInfoWithMessage", new Object[]{batch.getId(), state, errorMessage}));
                this.writeError(row, errorMessage);
                continue;
            }
            if (res == null || res.isEmpty()) {
                String msg = Messages.getMessage(this.getClass(), "noResultForRow", new Object[]{batch.getId(), state});
                this.writeError(row, msg);
                this.getLogger().warn(msg);
                continue;
            }
            RowResult rowResult = new RowResult(Boolean.valueOf((String)res.get(successIdx)), this.isDelete ? false : Boolean.valueOf((String)res.get(createdIdx)), (String)res.get(idIdx), (String)res.get(errIdx));
            this.writeRowResult(row, rowResult);
        }
    }

    private Map<String, BatchInfo> createBatchInfoMap() throws AsyncApiException {
        HashMap<String, BatchInfo> batchInfoMap = new HashMap<String, BatchInfo>();
        for (BatchInfo bi : this.jobUtil.getBatches().getBatchInfo()) {
            batchInfoMap.put(bi.getId(), bi);
        }
        return batchInfoMap;
    }

    private DataReader resetDAO() throws DataAccessObjectInitializationException, LoadException {
        DataReader dataReader = (DataReader)this.getController().getDao();
        dataReader.close();
        dataReader.open();
        DAORowUtil.get().skipRowToStartOffset(this.getConfig(), dataReader, this.getProgressMonitor(), true);
        return dataReader;
    }

    private void writeRowResult(Row row, RowResult resultRow) throws DataAccessObjectException {
        if (resultRow.success) {
            String successMessage;
            switch (this.getConfig().getOperationInfo()) {
                case hard_delete: {
                    successMessage = "statusItemHardDeleted";
                    break;
                }
                case delete: {
                    successMessage = "statusItemDeleted";
                    break;
                }
                default: {
                    successMessage = resultRow.created ? "statusItemCreated" : "statusItemUpdated";
                }
            }
            this.writeSuccess(row, resultRow.id, Messages.getMessage(this.getClass(), successMessage, new Object[0]));
        } else {
            this.writeError(row, this.parseAsyncApiError(resultRow.error));
        }
    }

    private Map<String, Integer> mapHeaderIndices(List<String> header) {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (int i = 0; i < header.size(); ++i) {
            indices.put(header.get(i), i);
        }
        return indices;
    }

    private void sanityCheckBatch(BatchData clientBatchInfo, BatchInfo batch) throws LoadException {
        String batchId = clientBatchInfo.batchId;
        assert (batchId != null && batchId.equals(batch.getId()));
        assert (this.jobUtil.getJobId().equals(batch.getJobId()));
        assert (clientBatchInfo.numRows > 0);
        int recordsProcessed = batch.getNumberRecordsProcessed();
        BatchStateEnum state = batch.getState();
        if (state != BatchStateEnum.Completed && state != BatchStateEnum.Failed) {
            this.sanityCheckError(batchId, "Expected batch state to be Completed or Failed, but was " + state);
        }
    }

    private void sanityCheckError(String id, String errMsg) throws LoadException {
        throw new LoadException(id + ": " + errMsg);
    }

    private String parseAsyncApiError(String errString) {
        String sep = ":";
        String suffix = "--";
        int lastSep = errString.lastIndexOf(":");
        if (lastSep > 0 && errString.endsWith("--")) {
            String fields = errString.substring(lastSep + 1, errString.length() - "--".length());
            String start = errString.substring(0, lastSep);
            if (fields != null && fields.length() > 0) {
                return start + "\n" + "Error fields: " + fields;
            }
            return start;
        }
        return errString;
    }

    @Override
    protected void convertBulkAPINulls(Row row) {
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            if (!NATextValue.isNA(entry.getValue())) continue;
            entry.setValue(NATextValue.getInstance());
        }
    }

    @Override
    protected void conversionFailed(Row row, String errMsg) throws DataAccessObjectException, OperationException {
        super.conversionFailed(row, errMsg);
        this.getLogger().warn("Skipping results for row " + row + " which failed before upload to Saleforce.com");
        this.allBatchesInOrder.add(new BatchData(SKIP_BATCH_ID, 1));
    }

    static {
        DATE_FMT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static class RowResult {
        final boolean success;
        final boolean created;
        final String id;
        final String error;

        RowResult(boolean success, boolean created, String id, String error) {
            this.success = success;
            this.created = created;
            this.id = id;
            this.error = error;
        }
    }

    private class BatchData {
        final String batchId;
        final int numRows;

        BatchData(String batchId, int numRows) {
            this.batchId = batchId;
            this.numRows = numRows;
        }
    }
}

