/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.util.LoadRateCalculator;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchInfoList;
import com.sforce.async.BulkConnection;
import com.sforce.async.CSVReader;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.OperationEnum;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class BulkApiVisitorUtil {
    private static final Logger logger = Logger.getLogger(BulkApiVisitorUtil.class);
    private final BulkConnection client;
    private JobInfo jobInfo;
    private int recordsProcessed;
    private final Map<String, InputStream> attachments = new HashMap<String, InputStream>();
    private int attachmentNum;
    private final long checkStatusInterval;
    private long lastStatusUpdate;
    private final ILoaderProgress monitor;
    private final LoadRateCalculator rateCalc;
    private final boolean updateProgress;
    private static final NumberFormat FILE_NUM_FMT;

    BulkApiVisitorUtil(Controller ctl, ILoaderProgress monitor, LoadRateCalculator rateCalc, boolean updateProgress) {
        this.client = ctl.getBulkClient().getClient();
        try {
            long checkStatusInt = ctl.getConfig().getLong("sfdc.bulkApiCheckStatusInterval");
            this.checkStatusInterval = checkStatusInt > 0L ? checkStatusInt : 5000L;
        }
        catch (ParameterLoadException e) {
            throw new RuntimeException("Failed to initialize check status interval", e);
        }
        this.monitor = monitor;
        this.rateCalc = rateCalc;
        this.updateProgress = updateProgress;
    }

    BulkApiVisitorUtil(Controller ctl, ILoaderProgress monitor, LoadRateCalculator rateCalc) {
        this(ctl, monitor, rateCalc, true);
    }

    String getJobId() {
        return this.jobInfo.getId();
    }

    void createJob(Config cfg) throws AsyncApiException {
        String assRule;
        JobInfo job = new JobInfo();
        OperationEnum op = cfg.getOperationInfo().getOperationEnum();
        job.setOperation(op);
        if (op == OperationEnum.upsert) {
            job.setExternalIdFieldName(cfg.getString("sfdc.externalIdField"));
        }
        job.setObject(cfg.getString("sfdc.entity"));
        job.setContentType(cfg.getBoolean("sfdc.bulkApiZipContent") && op != OperationEnum.query ? ContentType.ZIP_CSV : ContentType.CSV);
        job.setConcurrencyMode(cfg.getBoolean("sfdc.bulkApiSerialMode") ? ConcurrencyMode.Serial : ConcurrencyMode.Parallel);
        if (!(op != OperationEnum.update && op != OperationEnum.upsert && op != OperationEnum.insert || (assRule = cfg.getString("sfdc.assignmentRule")) == null || assRule.length() != 15 && assRule.length() != 18)) {
            job.setAssignmentRuleId(assRule);
        }
        job = this.client.createJob(job);
        logger.info(Messages.getMessage(this.getClass(), "logJobCreated", job.getId()));
        this.jobInfo = job;
    }

    String addAttachment(byte[] fileContents) {
        String name = "attachment_" + FILE_NUM_FMT.format(this.attachmentNum++);
        this.attachments.put(name, new ByteArrayInputStream(fileContents));
        return "#" + name;
    }

    BatchInfo createBatch(InputStream batchContent) throws AsyncApiException {
        BatchInfo batch = this.jobInfo.getContentType() == ContentType.ZIP_CSV ? this.client.createBatchWithInputStreamAttachments(this.jobInfo, batchContent, this.attachments) : this.client.createBatchFromStream(this.jobInfo, batchContent);
        logger.info(Messages.getMessage(this.getClass(), "logBatchLoaded", batch.getId()));
        return batch;
    }

    long periodicCheckStatus() throws AsyncApiException {
        if (this.monitor.isCanceled()) {
            return 0L;
        }
        long timeRemaining = this.checkStatusInterval - (System.currentTimeMillis() - this.lastStatusUpdate);
        if (timeRemaining <= 0L) {
            this.jobInfo = this.client.getJobStatus(this.getJobId());
            this.updateJobStatus();
            return this.checkStatusInterval;
        }
        this.monitor.setNumberBatchesTotal(this.jobInfo.getNumberBatchesTotal());
        return timeRemaining;
    }

    private void awaitJobCompletion() throws AsyncApiException {
        long sleepTime = this.periodicCheckStatus();
        while (this.jobInfo.getNumberBatchesQueued() > 0 || this.jobInfo.getNumberBatchesInProgress() > 0) {
            if (this.monitor.isCanceled()) {
                return;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sleepTime = this.periodicCheckStatus();
        }
    }

    boolean hasJob() {
        return this.jobInfo != null;
    }

    void closeJob() throws AsyncApiException {
        this.jobInfo = this.client.closeJob(this.getJobId());
        this.updateJobStatus();
        this.awaitJobCompletion();
    }

    private void updateJobStatus() {
        if (this.updateProgress) {
            this.monitor.worked(this.jobInfo.getNumberRecordsProcessed() - this.recordsProcessed);
            this.monitor.setSubTask(this.rateCalc.calculateSubTask(this.jobInfo.getNumberRecordsProcessed(), this.jobInfo.getNumberRecordsFailed()));
            this.recordsProcessed = this.jobInfo.getNumberRecordsProcessed();
        }
        this.lastStatusUpdate = System.currentTimeMillis();
        logger.info(Messages.getMessage(this.getClass(), "logJobStatus", this.jobInfo.getNumberBatchesQueued(), this.jobInfo.getNumberBatchesInProgress(), this.jobInfo.getNumberBatchesCompleted(), this.jobInfo.getNumberBatchesFailed()));
    }

    BatchInfoList getBatches() throws AsyncApiException {
        return this.client.getBatchInfoList(this.getJobId());
    }

    CSVReader getBatchResults(String batchId) throws AsyncApiException {
        return new CSVReader(this.client.getBatchResultStream(this.getJobId(), batchId));
    }

    static {
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        fmt.setGroupingUsed(false);
        fmt.setMinimumIntegerDigits(3);
        FILE_NUM_FMT = fmt;
    }
}

