/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.IVisitor;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.mapping.Mapper;
import com.salesforce.dataloader.model.Row;
import com.salesforce.dataloader.util.LoadRateCalculator;
import org.apache.log4j.Logger;

public abstract class AbstractVisitor
implements IVisitor {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Controller controller;
    private final ILoaderProgress monitor;
    private final DataWriter successWriter;
    private final DataWriter errorWriter;
    private int errors;
    private int successes;
    private final LoadRateCalculator rateCalculator;

    public AbstractVisitor(Controller controller, ILoaderProgress monitor, DataWriter successWriter, DataWriter errorWriter) {
        this.controller = controller;
        this.monitor = monitor;
        this.successWriter = successWriter;
        this.errorWriter = errorWriter;
        this.rateCalculator = new LoadRateCalculator();
    }

    protected abstract boolean writeStatus();

    protected void addSuccess() {
        ++this.successes;
    }

    @Override
    public int getNumberOfRows() {
        return this.getNumberErrors() + this.getNumberSuccesses();
    }

    @Override
    public int getNumberErrors() {
        return this.errors;
    }

    @Override
    public int getNumberSuccesses() {
        return this.successes;
    }

    protected Controller getController() {
        return this.controller;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected ILoaderProgress getProgressMonitor() {
        return this.monitor;
    }

    protected Config getConfig() {
        return this.getController().getConfig();
    }

    protected Mapper getMapper() {
        return this.getController().getMapper();
    }

    protected void writeSuccess(Row row, String id, String message) throws DataAccessObjectException {
        if (this.writeStatus()) {
            if (id != null && id.length() > 0) {
                row.put("ID", (Object)id);
            }
            if (message != null && message.length() > 0) {
                row.put("STATUS", (Object)message);
            }
            this.successWriter.writeRow(row);
        }
        this.addSuccess();
    }

    protected void writeError(Row row, String errorMessage) throws DataAccessObjectException {
        if (this.writeStatus()) {
            if (row == null) {
                row = Row.singleEntryImmutableRow("ERROR", errorMessage);
            } else {
                row.put("ERROR", (Object)errorMessage);
            }
            this.errorWriter.writeRow(row);
        }
        ++this.errors;
    }

    protected LoadRateCalculator getRateCalculator() {
        return this.rateCalculator;
    }
}

