/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.visitor;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.AbstractVisitor;
import com.salesforce.dataloader.action.visitor.IQueryVisitor;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.ExtractException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.mapping.SOQLMapper;
import com.salesforce.dataloader.model.Row;
import com.sforce.async.AsyncApiException;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.ws.ConnectionException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

abstract class AbstractQueryVisitor
extends AbstractVisitor
implements IQueryVisitor {
    private final DataWriter queryWriter;
    private final String soql;
    private final List<Row> batchRows;
    private final List<String> batchIds;
    private final int batchSize;

    public AbstractQueryVisitor(Controller controller, ILoaderProgress monitor, DataWriter queryWriter, DataWriter successWriter, DataWriter errorWriter) {
        super(controller, monitor, successWriter, errorWriter);
        this.queryWriter = queryWriter;
        this.soql = this.getConfig().getString("sfdc.extractionSOQL");
        this.batchRows = new LinkedList<Row>();
        this.batchIds = new LinkedList<String>();
        this.batchSize = this.getWriteBatchSize();
    }

    @Override
    public final void visit() throws DataAccessObjectException, OperationException {
        try {
            if (this.getProgressMonitor().isCanceled()) {
                return;
            }
            int size = this.executeQuery(this.getSoql());
            if (size == 0) {
                this.getLogger().info(Messages.getMessage(this.getClass(), "noneReturned", new Object[0]));
            } else {
                if (this.getProgressMonitor().isCanceled()) {
                    return;
                }
                this.startWriteExtraction(size);
                this.writeExtraction();
                this.flushResults();
            }
        }
        catch (ApiFault e) {
            throw new ExtractException(e.getExceptionMessage(), e);
        }
        catch (ConnectionException e) {
            throw new ExtractException(e.getMessage(), e);
        }
        catch (AsyncApiException e) {
            throw new ExtractException(e.getExceptionMessage(), e);
        }
    }

    protected abstract void writeExtraction() throws AsyncApiException, ExtractException, DataAccessObjectException, ConnectionException;

    protected abstract int executeQuery(String var1) throws ConnectionException, AsyncApiException, OperationException;

    @Override
    protected boolean writeStatus() {
        return this.getConfig().getBoolean("process.enableExtractStatusOutput");
    }

    private String getSoql() {
        return this.soql;
    }

    private DataWriter getQueryWriter() {
        return this.queryWriter;
    }

    protected void addResultRow(Row row, String id) throws DataAccessObjectException {
        this.batchRows.add(row);
        this.batchIds.add(id);
        if (this.batchSize == this.batchRows.size()) {
            this.writeBatch();
        }
    }

    private void flushResults() throws DataAccessObjectException {
        if (!this.batchRows.isEmpty()) {
            this.writeBatch();
        }
    }

    private void writeBatch() throws DataAccessObjectException {
        if (this.getProgressMonitor().isCanceled()) {
            return;
        }
        try {
            if (this.getQueryWriter().writeRowList(this.batchRows)) {
                this.writeSuccesses();
            } else {
                this.writeErrors(Messages.getMessage(this.getClass(), "statusErrorNotWritten", this.getConfig().getString("dataAccess.name")));
            }
            this.getProgressMonitor().worked(this.batchRows.size());
            this.getProgressMonitor().setSubTask(this.getRateCalculator().calculateSubTask(this.getNumberOfRows(), this.getNumberErrors()));
        }
        catch (DataAccessObjectInitializationException ex) {
            throw ex;
        }
        catch (DataAccessObjectException ex) {
            this.writeErrors(Messages.getMessage(this.getClass(), "statusErrorNotWrittenException", this.getConfig().getString("dataAccess.name"), ex.getMessage()));
        }
        finally {
            this.batchRows.clear();
            this.batchIds.clear();
        }
    }

    private void writeSuccesses() throws DataAccessObjectException {
        String msg = Messages.getMessage(this.getClass(), "statusItemQueried", new Object[0]);
        Iterator<String> ids = this.batchIds.iterator();
        for (Row row : this.batchRows) {
            this.writeSuccess(row, ids.next(), msg);
        }
    }

    private void writeErrors(String errorMessage) throws DataAccessObjectException {
        for (Row row : this.batchRows) {
            this.writeError(row, errorMessage);
        }
    }

    protected int getWriteBatchSize() {
        int daoBatchSize;
        try {
            daoBatchSize = this.getConfig().getInt("dataAccess.writeBatchSize");
            if (daoBatchSize > 2000) {
                daoBatchSize = 2000;
            }
        }
        catch (ParameterLoadException e) {
            this.getLogger().warn(Messages.getMessage(this.getClass(), "errorGettingBatchSize", String.valueOf(500), e.getMessage()));
            daoBatchSize = 500;
        }
        return daoBatchSize;
    }

    protected void startWriteExtraction(int size) {
        this.getRateCalculator().start();
        this.getRateCalculator().setNumRecords(size);
        this.getProgressMonitor().beginTask(Messages.getMessage(this.getClass(), "extracting", new Object[0]), size);
    }

    @Override
    protected SOQLMapper getMapper() {
        return (SOQLMapper)super.getMapper();
    }
}

