/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action.progress;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.LoadFinishDialog;
import com.salesforce.dataloader.ui.LoaderWindow;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.extraction.ExtractionFinishDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class SWTProgressAdapter
implements ILoaderProgress {
    private IProgressMonitor monitor = null;
    private String dispMessage;
    private final Controller controller;

    public SWTProgressAdapter(IProgressMonitor monitor_, Controller controller) {
        this.monitor = monitor_;
        this.controller = controller;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.monitor.beginTask(name, totalWork);
    }

    public void done() {
        this.monitor.done();
    }

    @Override
    public void doneSuccess(String message) {
        this.monitor.done();
        this.dispMessage = message;
        Display.getDefault().syncExec(new Thread(){

            @Override
            public void run() {
                if (SWTProgressAdapter.this.controller.getConfig().getOperationInfo().isExtraction()) {
                    ExtractionFinishDialog dlg = new ExtractionFinishDialog(LoaderWindow.getApp().getShell(), SWTProgressAdapter.this.controller);
                    dlg.setMessage(SWTProgressAdapter.this.dispMessage);
                    dlg.open();
                } else {
                    LoadFinishDialog dlg = new LoadFinishDialog(LoaderWindow.getApp().getShell(), SWTProgressAdapter.this.controller);
                    dlg.setMessage(SWTProgressAdapter.this.dispMessage);
                    dlg.open();
                }
            }
        });
    }

    @Override
    public void doneError(String message) {
        this.monitor.done();
        this.dispMessage = message;
        Display.getDefault().syncExec(new Thread(){

            @Override
            public void run() {
                UIUtils.errorMessageBox(LoaderWindow.getApp().getShell(), SWTProgressAdapter.this.dispMessage);
            }
        });
    }

    @Override
    public void worked(int worked) {
        this.monitor.worked(worked);
    }

    public void setTaskName(String name) {
        this.monitor.setTaskName(name);
    }

    @Override
    public void setSubTask(String name) {
        this.monitor.subTask(name);
    }

    @Override
    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    @Override
    public void setNumberBatchesTotal(int numberBatchesTotal) {
    }
}

