/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action;

import com.salesforce.dataloader.action.BulkExtractAction;
import com.salesforce.dataloader.action.BulkLoadAction;
import com.salesforce.dataloader.action.DeleteAction;
import com.salesforce.dataloader.action.IAction;
import com.salesforce.dataloader.action.InsertAction;
import com.salesforce.dataloader.action.PartnerExtractAction;
import com.salesforce.dataloader.action.PartnerExtractAllAction;
import com.salesforce.dataloader.action.UpdateAction;
import com.salesforce.dataloader.action.UpsertAction;
import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoadWizard;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.extraction.ExtractAllWizard;
import com.salesforce.dataloader.ui.extraction.ExtractionWizard;
import com.salesforce.dataloader.ui.uiActions.OperationUIAction;
import com.sforce.async.OperationEnum;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public enum OperationInfo {
    insert(InsertAction.class, LoadWizard.InsertWizard.class),
    update(UpdateAction.class, LoadWizard.UpdateWizard.class),
    upsert(UpsertAction.class, LoadWizard.UpsertWizard.class),
    delete(DeleteAction.class, LoadWizard.DeleteWizard.class),
    hard_delete(null, BulkLoadAction.class, LoadWizard.HardDeleteWizard.class),
    extract(PartnerExtractAction.class, BulkExtractAction.class, ExtractionWizard.class),
    extract_all(PartnerExtractAllAction.class, null, ExtractAllWizard.class);

    public static final OperationInfo[] ALL_OPERATIONS_IN_ORDER;
    private static final Logger logger;
    private final Class<? extends IAction> partnerAPIActionClass;
    private final Class<? extends IAction> bulkAPIActionClass;
    private final Class<? extends Wizard> wizardClass;

    private OperationInfo(Class<? extends IAction> partnerAPIActionClass, Class<? extends IAction> bulkAPIActionClass, Class<? extends Wizard> wizardClass) {
        this.partnerAPIActionClass = partnerAPIActionClass;
        this.bulkAPIActionClass = bulkAPIActionClass;
        this.wizardClass = wizardClass;
    }

    private OperationInfo(Class<? extends IAction> partnerAPIActionClass, Class<? extends Wizard> wizardClass) {
        this(partnerAPIActionClass, BulkLoadAction.class, wizardClass);
    }

    public boolean bulkAPIEnabled() {
        return this.bulkAPIActionClass != null;
    }

    public boolean partnerAPIEnabled() {
        return this.partnerAPIActionClass != null;
    }

    public IAction instantiateAction(Controller ctl, ILoaderProgress loaderProgress) {
        logger.info(Messages.getMessage(((Object)((Object)this)).getClass(), "createAction", new Object[]{this}));
        Class<? extends IAction> cls = ctl.getConfig().isBulkAPIEnabled() && this.bulkAPIEnabled() ? this.bulkAPIActionClass : this.partnerAPIActionClass;
        try {
            return cls.getConstructor(Controller.class, ILoaderProgress.class).newInstance(ctl, loaderProgress);
        }
        catch (Exception e) {
            throw this.unsupportedInstantiation(e, cls);
        }
    }

    private RuntimeException unsupportedInstantiation(Exception e, Class<?> cls) {
        String message = Messages.getMessage(((Object)((Object)this)).getClass(), "errorOperationInstantiation", new Object[]{this, String.valueOf(cls)});
        logger.fatal(message);
        return new UnsupportedOperationException(message, e);
    }

    public String getIconName() {
        if (this == hard_delete) {
            return delete.getIconName();
        }
        if (this == upsert) {
            return update.getIconName();
        }
        if (this == extract_all) {
            return extract.getIconName();
        }
        return this.name() + "_icon";
    }

    public String getIconLocation() {
        if (this == hard_delete) {
            return delete.getIconLocation();
        }
        if (this == extract_all) {
            return extract.getIconLocation();
        }
        return "img/icons/icon_" + this.name() + ".gif";
    }

    public String getMenuLabel() {
        return Labels.getString(this.name() + ".UIAction.menuText");
    }

    public String getToolTipText() {
        return Labels.getString(this.name() + ".UIAction.tooltipText");
    }

    public String getLabel() {
        return Labels.getString("UI." + this.name());
    }

    public Wizard instantiateWizard(Controller ctl) {
        logger.info(Messages.getMessage(((Object)((Object)this)).getClass(), "creatingWizard", new Object[]{this}));
        try {
            return this.wizardClass.getConstructor(Controller.class).newInstance(ctl);
        }
        catch (Exception e) {
            throw this.unsupportedInstantiation(e, this.wizardClass);
        }
    }

    public OperationUIAction createUIAction(Controller ctl) {
        return new OperationUIAction(ctl, this);
    }

    public OperationEnum getOperationEnum() {
        switch (this) {
            case hard_delete: {
                return OperationEnum.hardDelete;
            }
            case extract: {
                return OperationEnum.query;
            }
        }
        return OperationEnum.valueOf(this.name());
    }

    public boolean isDelete() {
        return this == delete || this == hard_delete;
    }

    public int getDialogIdx() {
        return 1024 + this.ordinal() + 1;
    }

    public boolean isOperationAllowed(Config cfg) {
        return this != hard_delete || cfg.isBulkAPIEnabled();
    }

    public Image getIconImage() {
        Image result = UIUtils.getImageRegistry().get(this.getIconName());
        if (result == null) {
            throw new NullPointerException(this.name() + ": cannot find image: " + this.getIconName() + ", " + this.getIconLocation());
        }
        return result;
    }

    public ImageDescriptor getIconImageDescriptor() {
        ImageDescriptor result = UIUtils.getImageRegistry().getDescriptor(this.getIconName());
        if (result == null) {
            throw new NullPointerException(this.name() + ": cannot find image descriptor: " + this.getIconName() + ", " + this.getIconLocation());
        }
        return result;
    }

    public String getInfoMessageForDataSelectionPage() {
        if (this == hard_delete) {
            return Labels.getString("DataSelectionPage." + this.name());
        }
        return null;
    }

    public boolean isExtraction() {
        return this == extract || this == extract_all;
    }

    static {
        ALL_OPERATIONS_IN_ORDER = new OperationInfo[]{insert, update, upsert, delete, hard_delete, extract, extract_all};
        logger = Logger.getLogger(OperationInfo.class);
    }
}

