/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action;

import com.salesforce.dataloader.action.AbstractAction;
import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.DAOLoadVisitor;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataAccessObject;
import com.salesforce.dataloader.dao.DataReader;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.mapping.LoadMapper;
import com.salesforce.dataloader.model.Row;
import com.salesforce.dataloader.util.DAORowUtil;
import com.sforce.ws.ConnectionException;
import java.util.List;

abstract class AbstractLoadAction
extends AbstractAction {
    protected AbstractLoadAction(Controller controller, ILoaderProgress monitor) throws DataAccessObjectInitializationException {
        super(controller, monitor);
    }

    @Override
    protected abstract DAOLoadVisitor createVisitor();

    @Override
    protected void checkDao(DataAccessObject dao) throws DataAccessObjectInitializationException {
        if (!(dao instanceof DataReader)) {
            String errMsg = this.getMessage("errorWrongDao", this.getConfig().getString("dataAccess.type"), "csvRead or databaseRead", this.getConfig().getString("process.operation"));
            this.getLogger().fatal(errMsg);
            throw new DataAccessObjectInitializationException(errMsg);
        }
    }

    @Override
    protected boolean visit() throws DataAccessObjectException, ParameterLoadException, OperationException, ConnectionException {
        int loadBatchSize = this.getConfig().getLoadBatchSize();
        List<Row> daoRowList = this.getDao().readRowList(loadBatchSize);
        if (daoRowList == null || daoRowList.size() == 0) {
            return false;
        }
        for (Row daoRow : daoRowList) {
            if (!DAORowUtil.isValidRow(daoRow)) {
                return false;
            }
            this.getVisitor().visit(daoRow);
        }
        return true;
    }

    @Override
    protected void flush() throws OperationException, DataAccessObjectException {
        this.getVisitor().flushRemaining();
    }

    @Override
    protected void initOperation() throws MappingInitializationException, DataAccessObjectException, OperationException {
        ((LoadMapper)this.getController().getMapper()).verifyMappingsAreValid();
        this.getMonitor().beginTask(this.getMessage("loading", this.getConfig().getString("process.operation")), this.getDao().getTotalRows());
        DAORowUtil.get().skipRowToStartOffset(this.getConfig(), this.getDao(), this.getMonitor(), !this.getConfig().isBulkAPIEnabled());
    }

    @Override
    protected List<String> getStatusColumns() {
        return this.getDao().getColumnNames();
    }

    @Override
    protected DataReader getDao() {
        return (DataReader)super.getDao();
    }

    @Override
    protected DAOLoadVisitor getVisitor() {
        return (DAOLoadVisitor)super.getVisitor();
    }

    @Override
    protected boolean writeStatus() {
        return true;
    }
}

