/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action;

import com.salesforce.dataloader.action.AbstractAction;
import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.IQueryVisitor;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataAccessObject;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.ExtractException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.mapping.SOQLMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

abstract class AbstractExtractAction
extends AbstractAction {
    protected AbstractExtractAction(Controller controller, ILoaderProgress monitor) throws DataAccessObjectInitializationException {
        super(controller, monitor);
    }

    @Override
    protected boolean visit() throws OperationException, DataAccessObjectException, ParameterLoadException {
        this.getVisitor().visit();
        return false;
    }

    @Override
    protected boolean writeStatus() {
        return this.getConfig().getBoolean("process.enableExtractStatusOutput");
    }

    @Override
    protected void checkDao(DataAccessObject dao) throws DataAccessObjectInitializationException {
        if (!(dao instanceof DataWriter)) {
            String errMsg = this.getMessage("errorWrongDao", this.getConfig().getString("dataAccess.type"), "csvWrite or databaseWrite", this.getConfig().getString("process.operation"));
            this.getLogger().fatal(errMsg);
            throw new DataAccessObjectInitializationException(errMsg);
        }
    }

    @Override
    protected DataWriter getDao() {
        return (DataWriter)super.getDao();
    }

    @Override
    protected IQueryVisitor getVisitor() {
        return (IQueryVisitor)super.getVisitor();
    }

    private List<String> getDaoColumns() {
        ((SOQLMapper)this.getController().getMapper()).initSoqlMapping(this.getConfig().getString("sfdc.extractionSOQL"));
        return ((SOQLMapper)this.getController().getMapper()).getDaoColumnsForSoql();
    }

    static List<String> getColumnsFromSoql(String soql, Logger logger) throws ExtractException {
        if (soql == null || soql.length() == 0) {
            String errMsg = Messages.getMessage(AbstractExtractAction.class, "errorEmptyQuery", new Object[0]);
            logger.error(errMsg);
            throw new ExtractException(errMsg);
        }
        String trimmedSoql = soql.trim().replaceAll("[\\s]*,[\\s]*", ",");
        String upperSOQL = trimmedSoql.toUpperCase();
        int selectPos = upperSOQL.indexOf("SELECT ");
        if (selectPos == -1) {
            String errMsg = Messages.getMessage(AbstractExtractAction.class, "errorMissingSelect", soql);
            logger.error(errMsg);
            throw new ExtractException(errMsg);
        }
        int fieldListStart = selectPos + "SELECT ".length();
        int fieldListEnd = upperSOQL.indexOf(" FROM ");
        try {
            String fieldString = trimmedSoql.substring(fieldListStart, fieldListEnd).trim();
            String[] fields = fieldString.split(",");
            return new ArrayList<String>(Arrays.asList(fields));
        }
        catch (Exception e) {
            String errMsg = fieldListStart < "SELECT ".length() ? Messages.getMessage(AbstractExtractAction.class, "errorMissingSelect", soql) : (fieldListEnd < 0 ? Messages.getMessage(AbstractExtractAction.class, "errorMissingFrom", soql) : Messages.getMessage(AbstractExtractAction.class, "errorMalformedQuery", soql));
            logger.error(errMsg, e);
            throw new ExtractException(errMsg);
        }
    }

    @Override
    protected List<String> getStatusColumns() throws ExtractException {
        return this.getDaoColumns();
    }

    @Override
    protected void initOperation() throws DataAccessObjectInitializationException, OperationException {
        List<String> daoColumns = this.getDaoColumns();
        this.getDao().setColumnNames(daoColumns);
    }

    @Override
    protected void flush() {
    }
}

