/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.action;

import com.salesforce.dataloader.action.IAction;
import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.IVisitor;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataAccessObject;
import com.salesforce.dataloader.dao.DataWriter;
import com.salesforce.dataloader.dao.csv.CSVFileWriter;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.LoadException;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.exception.OperationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.sforce.async.AsyncApiException;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

abstract class AbstractAction
implements IAction {
    private final ILoaderProgress monitor;
    private final Controller controller;
    private final IVisitor visitor;
    private final DataWriter successWriter;
    private final DataWriter errorWriter;
    private final DataAccessObject dao;
    private final Logger logger = Logger.getLogger(this.getClass());

    protected AbstractAction(Controller controller, ILoaderProgress monitor) throws DataAccessObjectInitializationException {
        this.monitor = monitor;
        this.controller = controller;
        this.checkDao(this.getController().getDao());
        this.dao = this.getController().getDao();
        if (this.writeStatus()) {
            this.successWriter = this.createSuccesWriter();
            this.errorWriter = this.createErrorWriter();
        } else {
            this.successWriter = null;
            this.errorWriter = null;
        }
        this.visitor = this.createVisitor();
    }

    protected abstract void checkDao(DataAccessObject var1) throws DataAccessObjectInitializationException;

    protected abstract IVisitor createVisitor();

    protected abstract void flush() throws OperationException, DataAccessObjectException;

    protected abstract void initOperation() throws DataAccessObjectInitializationException, OperationException, MappingInitializationException, DataAccessObjectException;

    protected abstract List<String> getStatusColumns() throws OperationException;

    protected abstract boolean visit() throws OperationException, DataAccessObjectException, ParameterLoadException, ConnectionException, AsyncApiException, ConnectionException;

    protected abstract boolean writeStatus();

    /*
     * Loose catch block
     */
    @Override
    public final void execute() {
        block36: {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            this.getLogger().info(this.getMessage("loading", this.getConfig().getString("process.operation")));
            this.getDao().open();
            this.initOperation();
            if (this.writeStatus()) {
                List<String> statusColumns = this.getStatusColumns();
                this.openSuccessWriter(statusColumns);
                this.openErrorWriter(statusColumns);
            }
            while (!this.getMonitor().isCanceled() && this.visit()) {
            }
            try {
                this.flush();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            try {
                this.closeAll();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            try {
                if (exceptions.size() == 0) {
                    Object[] args = new Object[]{String.valueOf(this.getVisitor().getNumberSuccesses()), this.getConfig().getString("process.operation"), String.valueOf(this.getVisitor().getNumberErrors())};
                    if (this.getMonitor().isCanceled()) {
                        this.getMonitor().doneSuccess(this.getMessage("cancel", args));
                    } else {
                        this.getMonitor().doneSuccess(this.getMessage("success", args));
                    }
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            if (exceptions.size() > 0) {
                exceptions.forEach(this::handleException);
            }
            break block36;
            catch (Exception e) {
                try {
                    exceptions.add(e);
                }
                catch (Throwable throwable) {
                    try {
                        this.flush();
                    }
                    catch (Exception e2) {
                        exceptions.add(e2);
                    }
                    try {
                        this.closeAll();
                    }
                    catch (Exception e3) {
                        exceptions.add(e3);
                    }
                    try {
                        if (exceptions.size() == 0) {
                            Object[] args = new Object[]{String.valueOf(this.getVisitor().getNumberSuccesses()), this.getConfig().getString("process.operation"), String.valueOf(this.getVisitor().getNumberErrors())};
                            if (this.getMonitor().isCanceled()) {
                                this.getMonitor().doneSuccess(this.getMessage("cancel", args));
                            } else {
                                this.getMonitor().doneSuccess(this.getMessage("success", args));
                            }
                        }
                    }
                    catch (Exception e4) {
                        exceptions.add(e4);
                    }
                    if (exceptions.size() > 0) {
                        exceptions.forEach(this::handleException);
                    }
                    throw throwable;
                }
                try {
                    this.flush();
                }
                catch (Exception e5) {
                    exceptions.add(e5);
                }
                try {
                    this.closeAll();
                }
                catch (Exception e6) {
                    exceptions.add(e6);
                }
                try {
                    if (exceptions.size() == 0) {
                        Object[] args = new Object[]{String.valueOf(this.getVisitor().getNumberSuccesses()), this.getConfig().getString("process.operation"), String.valueOf(this.getVisitor().getNumberErrors())};
                        if (this.getMonitor().isCanceled()) {
                            this.getMonitor().doneSuccess(this.getMessage("cancel", args));
                        } else {
                            this.getMonitor().doneSuccess(this.getMessage("success", args));
                        }
                    }
                }
                catch (Exception e7) {
                    exceptions.add(e7);
                }
                if (exceptions.size() > 0) {
                    exceptions.forEach(this::handleException);
                }
            }
        }
    }

    private void closeAll() {
        this.getDao().close();
        if (this.writeStatus()) {
            this.getSuccessWriter().close();
            this.getErrorWriter().close();
        }
    }

    protected Config getConfig() {
        return this.getController().getConfig();
    }

    protected Controller getController() {
        return this.controller;
    }

    protected DataAccessObject getDao() {
        return this.dao;
    }

    protected DataWriter getErrorWriter() {
        return this.errorWriter;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected String getMessage(String key, Object ... args) {
        String msg = Messages.getMessage(this.getClass(), key, true, args);
        return msg == null ? Messages.getMessage("Action", key, false, args) : msg;
    }

    protected ILoaderProgress getMonitor() {
        return this.monitor;
    }

    protected DataWriter getSuccessWriter() {
        return this.successWriter;
    }

    protected IVisitor getVisitor() {
        return this.visitor;
    }

    protected void handleException(Exception e) {
        String errMsg = e.getMessage();
        if (e instanceof ApiFault) {
            errMsg = ((ApiFault)e).getExceptionMessage();
        } else if (e instanceof AsyncApiException) {
            errMsg = ((AsyncApiException)e).getExceptionMessage();
        }
        this.getLogger().error(this.getMessage("exception", new Object[0]), e);
        this.getMonitor().doneError(errMsg);
    }

    private DataWriter createErrorWriter() throws DataAccessObjectInitializationException {
        String filename = this.getConfig().getString("process.outputError");
        if (filename == null || filename.length() == 0) {
            throw new DataAccessObjectInitializationException(this.getMessage("errorMissingErrorFile", new Object[0]));
        }
        return new CSVFileWriter(filename, this.getConfig());
    }

    private DataWriter createSuccesWriter() throws DataAccessObjectInitializationException {
        String filename = this.getConfig().getString("process.outputSuccess");
        if (filename == null || filename.length() == 0) {
            throw new DataAccessObjectInitializationException(this.getMessage("errorMissingSuccessFile", new Object[0]));
        }
        return new CSVFileWriter(filename, this.getConfig());
    }

    private void openErrorWriter(List<String> headers) throws OperationException {
        headers = new LinkedList<String>(headers);
        headers.add("ERROR");
        try {
            this.getErrorWriter().open();
            this.getErrorWriter().setColumnNames(headers);
        }
        catch (DataAccessObjectInitializationException e) {
            throw new OperationException(this.getMessage("errorOpeningErrorFile", this.getConfig().getString("process.outputError")), e);
        }
    }

    private void openSuccessWriter(List<String> headers) throws LoadException {
        if (!"ID".equals((headers = new LinkedList<String>(headers)).get(0))) {
            headers.add(0, "ID");
        }
        headers.add("STATUS");
        try {
            this.getSuccessWriter().open();
            this.getSuccessWriter().setColumnNames(headers);
        }
        catch (DataAccessObjectInitializationException e) {
            throw new LoadException(this.getMessage("errorOpeningSuccessFile", this.getConfig().getString("process.outputSuccess")), e);
        }
    }
}

